﻿/**********************************************************
 * 说明：管理员类Admin
 * 作者：chshnren1
 * 创建日期：9/15/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Admin 的摘要说明。
    /// </summary>
    public class Admin
    {
        #region 私有成员

        private int _adminID;		        //管理员ID
        private string _adminAccount;	    //管理员登录名
        private string _adminPassword;	    //管理员密码
        private int _adminLevel;	        //管理员级别
        private string _adminDescription;	//管理员说明

        private bool _exist;		//是否存在标志

        #endregion 私有成员

        #region 属性

        public int AdminID
        {
            set
            {
                this._adminID = value;
            }
            get
            {
                return this._adminID;
            }
        }
        public string AdminAccount
        {
            set
            {
                this._adminAccount = value;
            }
            get
            {
                return this._adminAccount;
            }
        }
        public string AdminPassword
        {
            set
            {
                this._adminPassword = value;
            }
            get
            {
                return this._adminPassword;
            }
        }
        public int AdminLevel
        {
            set
            {
                this._adminLevel = value;
            }
            get
            {
                return this._adminLevel;
            }
        }
        public string AdminDescription
        {
            set
            {
                this._adminDescription = value;
            }
            get
            {
                return this._adminDescription;
            }
        }
        public bool Exist
        {
            get
            {
                return this._exist;
            }
        }

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数adminAccount，获取管理员详细信息
        /// </summary>
        /// <param name="adminAccount">管理员登录名</param>
        public void LoadData(string adminAccount)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select AdminID,AdminAccount,AdminPassword,AdminLevel,AdminDescription from cai_Admins where AdminAccount = "
                + SqlStringConstructor.GetQuotedString(adminAccount);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this._adminID = GetSafeData.ValidateDataRow_N(dr, "AdminID");
                this._adminAccount = GetSafeData.ValidateDataRow_S(dr, "AdminAccount");
                this._adminPassword = GetSafeData.ValidateDataRow_S(dr, "AdminPassword");
                this._adminLevel = GetSafeData.ValidateDataRow_N(dr, "AdminLevel");
                this._adminDescription = GetSafeData.ValidateDataRow_S(dr, "AdminDescription");

                //解密密码
                //this._adminPassword = Encrypt.DecryptString(_adminPassword,_adminAccount);

                this._exist = true;
            }
            else
            {
                this._exist = false;
            }
        }

        /// <summary>
        /// 修改管理员数据
        /// </summary>
        /// <param name="htUserInfo">用户信息哈希表</param>
        public static void Update(Hashtable adminInfo, string where)
        {
            Database db = new Database();		        //实例化一个Database类
            db.Update("cai_Admins", adminInfo, where);	//利用Database类的Update方法修改管理员数据
        }
        #endregion 方法
    }
}