﻿/**********************************************************
 * 说明：工厂图片类Facpic
 * 作者：chshnren1
 * 创建日期：9/29/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    ///FacPic 的摘要说明
    /// </summary>
    public class FacPic
    {
        #region 属性

        public int facPicID { get; set; }               //工厂图片ID
        public int picClassID { get; set; }             //工厂图片ID
        public string facPicTitle { get; set; }         //工厂图片标题
        public string picPathSmall { get; set; }        //小图
        public string picPathBig { get; set; }          //大图
        public string seoTitle { get; set; }            //seo
        public string seoKeywords { get; set; }         //seo
        public string seoDesc { get; set; }             //seo
        public string facPicContent { get; set; }       //工厂图片内容
        public int clickTimes { get; set; }             //工厂图片点击次数
        public string addWho { get; set; }              //增加者
        public int isRecommended { get; set; }          //是否推荐
        public DateTime addTime { get; set; }           //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数facPicID，获取详细信息
        /// </summary>
        /// <param name="FacPicID">工厂图片ID</param>
        public void LoadData(int facPicID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select FacPicID,PicClassID,FacPicTitle,PicPathSmall,PicPathBig,SEOTitle,SeoKeywords,SeoDesc,FacPicContent,ClickTimes,AddWho,IsRecommended,AddTime From cai_FacPic where FacPicID = "
                + Convert.ToInt32(facPicID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.facPicID = GetSafeData.ValidateDataRow_N(dr, "FacPicID");
                this.picClassID = GetSafeData.ValidateDataRow_N(dr, "PicClassID");
                this.facPicTitle = GetSafeData.ValidateDataRow_S(dr, "FacPicTitle");
                this.picPathSmall = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall");
                this.picPathBig = GetSafeData.ValidateDataRow_S(dr, "PicPathBig");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.facPicContent = GetSafeData.ValidateDataRow_S(dr, "FacPicContent");
                this.clickTimes = GetSafeData.ValidateDataRow_N(dr, "ClickTimes");
                this.addWho = GetSafeData.ValidateDataRow_S(dr, "AddWho");
                this.isRecommended = GetSafeData.ValidateDataRow_N(dr, "IsRecommended");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按工厂图片ID排序,读取所有新闻信息
        /// </summary>
        /// <return></return>
        public static DataView QueryFacPic(string strSql)
        {

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// PicClassID
        /// </summary>
        /// <return></return>
        public static DataView QueryFacPicFilter(int picClassID)
        {

            string strSql = "";
            strSql = "select FacPicID,PicClassID,FacPicTitle,PicPathSmall,PicPathBig,SEOTitle,SeoKeywords,SeoDesc,FacPicContent,ClickTimes,AddWho,AddTime,PicClassName From cai_V_FacPic where PicClassID=" + picClassID + " order by FacPicID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加工厂图片
        /// </summary>
        /// <return></return>
        public void Add(Hashtable facpic)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_FacPic", facpic);
        }

        /// <summary>
        /// 修改工厂图片内容
        /// </summary>
        /// <param name="news"></param>
        public void Update(Hashtable facpic)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where FacPicID = " + this.facPicID;
            db.Update("cai_FacPic", facpic, strCond);
        }


        /// <summary>
        /// 删除工厂图片内容
        /// </summary>
        /// <param name="facpic"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_FacPic where FacPicID = " + this.facPicID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }

}