﻿/**********************************************************
 * 说明：反馈意见类Feedback
 * 作者：chshnren1
 * 创建日期：10/11/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Feedback的摘要说明。
    /// </summary>
    public class Feedback
    {
        #region 属性

        public int feedbackID { get; set; }		        //反馈意见ID
        public string fBStyle { get; set; }	            //反馈意见类型
        public string fBContent { get; set; }           //反馈意见内容
        public string companyName { get; set; }         //单位
        public string fBName { get; set; }              //反馈人姓名
        public string email { get; set; }               //E-mail
        public string fax { get; set; }                 //Fax
        public string tel { get; set; }                 //电话
        public string zipCode { get; set; }             //邮编
        public string address { get; set; }             //联系地址
        public DateTime addTime { get; set; }           //增加时间

        public bool exist;		//是否存在标志

        #endregion 属性


        #region 方法

        /// <summary>
        /// 根据参数FeedbackID，获取详细信息
        /// </summary>
        /// <param name="FeedbackID">反馈意见ID</param>
        public void LoadData(int feedbackID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select FeedbackID,FBStyle,FBContent,CompanyName,FBName,Email,Fax,Tel,ZipCode,Address,AddTime From cai_Feedback where FeedbackID = "
                + Convert.ToInt32(feedbackID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.feedbackID = GetSafeData.ValidateDataRow_N(dr, "FeedbackID");
                this.fBStyle = GetSafeData.ValidateDataRow_S(dr, "FBStyle");
                this.fBContent = GetSafeData.ValidateDataRow_S(dr, "FBContent");
                this.companyName = GetSafeData.ValidateDataRow_S(dr, "CompanyName");
                this.fBName = GetSafeData.ValidateDataRow_S(dr, "FBName");
                this.email = GetSafeData.ValidateDataRow_S(dr, "Email");
                this.fax = GetSafeData.ValidateDataRow_S(dr, "Fax");
                this.tel = GetSafeData.ValidateDataRow_S(dr, "Tel");
                this.zipCode = GetSafeData.ValidateDataRow_S(dr, "ZipCode");
                this.address = GetSafeData.ValidateDataRow_S(dr, "Address");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按ID排序,读取所有信息
        /// </summary>
        /// <return></return>
        public static DataView QueryFeedback()
        {

            string strSql = "";
            strSql = "select FeedbackID,FBStyle,CompanyName,FBName,Email,Fax,Tel,ZipCode,Address,AddTime From cai_Feedback order by FeedbackID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加反馈意见
        /// </summary>
        /// <return></return>
        public void Add(Hashtable feedback)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_Feedback", feedback);
        }

        /// <summary>
        /// 修改反馈意见内容
        /// </summary>
        /// <param name="Feedback"></param>
        public void Update(Hashtable feedback)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where FeedbackID = " + this.feedbackID;
            db.Update("cai_Feedback", feedback, strCond);
        }


        /// <summary>
        /// 删除反馈意见内容
        /// </summary>
        /// <param name="Feedback"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_Feedback where FeedbackID = " + this.feedbackID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
