﻿/**********************************************************
 * 说明：友情链接类FriendLink
 * 作者：chshnren1
 * 创建日期：3/13/2012
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// FriendLink的摘要说明。
    /// </summary>
    public class FriendLink
    {
        #region 属性

        public int linkID { get; set; }                 //友情链接ID
        public int linkSortID { get; set; }             //友情链接排序ID
        public string linkKeyword { get; set; }         //友情链接锚文本
        public string linkUrl { get; set; }             //链接网址
        public string linkDesc { get; set; }            //链接说明
        public string linkPic { get; set; }             //链接图片
        public DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数linkID，获取详细信息
        /// </summary>
        /// <param name="linkID">友情链接ID</param>
        public void LoadData(int linkID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select LinkID,LinkSortID,LinkKeyword,LinkUrl,LinkDesc,LinkPic,AddTime From cai_FriendLink where LinkID = "
                + Convert.ToInt32(linkID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.linkID = GetSafeData.ValidateDataRow_N(dr, "LinkID");
                this.linkSortID = GetSafeData.ValidateDataRow_N(dr, "LinkSortID");
                this.linkKeyword = GetSafeData.ValidateDataRow_S(dr, "LinkKeyword");
                this.linkUrl = GetSafeData.ValidateDataRow_S(dr, "LinkUrl");
                this.linkDesc = GetSafeData.ValidateDataRow_S(dr, "LinkDesc");
                this.linkPic = GetSafeData.ValidateDataRow_S(dr, "LinkPic");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按链接ID排序,读取所有友情链接信息
        /// </summary>
        /// <return></return>
        public static DataView QueryFriendLink(string strSql)
        {
            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加友情链接信息
        /// </summary>
        /// <return></return>
        public void Add(Hashtable links)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_FriendLink", links);
        }

        /// <summary>
        /// 修改友情链接信息
        /// </summary>
        /// <param name="links"></param>
        public void Update(Hashtable links)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where LinkID = " + this.linkID;
            db.Update("cai_FriendLink", links, strCond);
        }


        /// <summary>
        /// 删除友情链接信息
        /// </summary>
        /// <param name="linkID"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_FriendLink where LinkID = " + this.linkID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
