﻿/**********************************************************
 * 说明：留言类Guestbook
 * 作者：chshnren1
 * 创建日期：9/29/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Guestbook的摘要说明。
    /// </summary>
    public class Guestbook
    {
        #region 属性

        public int guestBookID { get; set; }		    //留言ID
        public string guestName { get; set; }	        //姓名
        public string guestPosition { get; set; }       //职位
        public string sex { get; set; }                 //性别
        public string companyName { get; set; }         //单位
        public string tel { get; set; }                 //电话
        public string email { get; set; }               //邮箱
        public string webSite { get; set; }             //网址
        public string guestContent { get; set; }        //内容
        public DateTime addTime { get; set; }           //增加时间

        public bool exist;		//是否存在标志

        #endregion 属性


        #region 方法

        /// <summary>
        /// 根据参数guestBookID，获取详细信息
        /// </summary>
        /// <param name="GuestBookID">留言ID</param>
        public void LoadData(int guestBookID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select GuestBookID,GuestName,GuestPosition,Sex,CompanyName,Tel,Email,WebSite,GuestContent,AddTime From cai_GuestBook where GuestBookID = "
                + Convert.ToInt32(guestBookID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.guestBookID = GetSafeData.ValidateDataRow_N(dr, "GuestBookID");
                this.guestName = GetSafeData.ValidateDataRow_S(dr, "GuestName");
                this.guestPosition = GetSafeData.ValidateDataRow_S(dr, "GuestPosition");
                this.sex = GetSafeData.ValidateDataRow_S(dr, "Sex");
                this.companyName = GetSafeData.ValidateDataRow_S(dr, "CompanyName");
                this.tel = GetSafeData.ValidateDataRow_S(dr, "Tel");
                this.email = GetSafeData.ValidateDataRow_S(dr, "Email");
                this.webSite = GetSafeData.ValidateDataRow_S(dr, "WebSite");
                this.guestContent = GetSafeData.ValidateDataRow_S(dr, "GuestContent");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按留言ID排序,读取所有留言信息
        /// </summary>
        /// <return></return>
        public static DataView QueryGuestBook()
        {

            string strSql = "";
            strSql = "select GuestBookID,GuestName,Tel,GuestPosition,Sex,CompanyName,AddTime From cai_GuestBook order by GuestBookID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加留言
        /// </summary>
        /// <return></return>
        public void Add(Hashtable guestbook)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_GuestBook", guestbook);
        }

        /// <summary>
        /// 修改留言内容
        /// </summary>
        /// <param name="Guestbook"></param>
        public void Update(Hashtable guestbook)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where GuestBookID = " + this.guestBookID;
            db.Update("cai_GuestBook", guestbook, strCond);
        }


        /// <summary>
        /// 删除留言内容
        /// </summary>
        /// <param name="Guestbook"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_GuestBook where GuestBookID = " + this.guestBookID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
