﻿/**********************************************************
 * 说明：工作类Jobs
 * 作者：chshnren1
 * 创建日期：9/30/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Jobs的摘要说明。
    /// </summary>
    public class Jobs
    {
        #region 属性

        public int jobID { get; set; }                  //职位ID
        public string jobPosition { get; set; }         //职位名称
        public string jobDepartment { get; set; }       //招聘部门
        public string workAddress { get; set; }         //工作地点
        public string attermTime { get; set; }          //有效期限
        public string jobDemand { get; set; }           //职位要求
        private DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数JobID，获取详细信息
        /// </summary>
        /// <param name="JobID">职位ID</param>
        public void LoadData(int jobID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select JobID,JobPosition,JobDepartment,WorkAddress,AttermTime,JobDemand,AddTime From cai_Job where JobID = "
                + Convert.ToInt32(jobID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.jobID = GetSafeData.ValidateDataRow_N(dr, "JobID");
                this.jobPosition = GetSafeData.ValidateDataRow_S(dr, "JobPosition");
                this.jobDepartment = GetSafeData.ValidateDataRow_S(dr, "JobDepartment");
                this.workAddress = GetSafeData.ValidateDataRow_S(dr, "WorkAddress");
                this.attermTime = GetSafeData.ValidateDataRow_S(dr, "AttermTime");
                this.jobDemand = GetSafeData.ValidateDataRow_S(dr, "JobDemand");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按职位ID排序,读取所有招聘信息
        /// </summary>
        /// <return></return>
        public static DataView QueryJobs()
        {

            string strSql = "";
            strSql = "select JobID,JobPosition,JobDepartment,WorkAddress,AttermTime,AddTime From cai_Job order by JobID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加职位信息
        /// </summary>
        /// <return></return>
        public void Add(Hashtable jobs)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_Job", jobs);
        }

        /// <summary>
        /// 修改职位信息
        /// </summary>
        /// <param name="jobs"></param>
        public void Update(Hashtable jobs)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where JobID = " + this.jobID;
            db.Update("cai_Job", jobs, strCond);
        }


        /// <summary>
        /// 删除职位信息
        /// </summary>
        /// <param name="jobs"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_Job where JobID = " + this.jobID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
