﻿/**********************************************************
 * 说明：资讯分类NewsClass
 * 作者：chshnren1
 * 创建日期：3/9/2012
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// NewsClass的摘要说明。
    /// </summary>
    public class NewsClass
    {
        #region 属性

        public int classID { get; set; }                //资讯分类ID
        public int classSortID { get; set; }            //资讯分类排序ID
        public string className { get; set; }           //资讯分类名称
        public string classNameBig5 { get; set; }       //资讯分类名称Big5
        public string classNameEn { get; set; }         //资讯分类名称En
        public string classPicPath { get; set; }        //分类图片路径
        public string seoTitle { get; set; }            //seo
        public string seoKeywords { get; set; }         //seo
        public string seoDesc { get; set; }             //seo
        public string addWho { get; set; }             //增加者
        private DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数classID，获取资讯分类信息
        /// </summary>
        /// <param name="classID">站点资讯分类ID</param>
        public void LoadData(int classID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select ClassID,ClassSortID,ClassName,ClassNameBig5,ClassNameEn,ClassPicPath,SeoTitle,SeoKeywords,SeoDesc,AddWho,AddTime From cai_NewsClass where ClassID = "
                + Convert.ToInt32(classID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.classID = GetSafeData.ValidateDataRow_N(dr, "ClassID");
                this.classSortID = GetSafeData.ValidateDataRow_N(dr, "ClassSortID");
                this.className = GetSafeData.ValidateDataRow_S(dr, "ClassName");
                this.classNameBig5 = GetSafeData.ValidateDataRow_S(dr, "ClassNameBig5");
                this.classNameEn = GetSafeData.ValidateDataRow_S(dr, "ClassNameEn");
                this.classPicPath = GetSafeData.ValidateDataRow_S(dr, "ClassPicPath");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.addWho = GetSafeData.ValidateDataRow_S(dr, "AddWho");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }


        /// <summary>
        /// 读取数据
        /// </summary>
        /// <return></return>
        public static DataView QueryNewsClass(string strSql)
        {
            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加新的资讯分类
        /// </summary>
        /// <return></return>
        public void Add(Hashtable cai_NewsClass)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_NewsClass", cai_NewsClass);
        }

        /// <summary>
        /// 修改站点信息分类数据
        /// </summary>
        /// <param name="classID"></param>
        public void Update(Hashtable cai_NewsClass)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where ClassID = " + this.classID;
            db.Update("cai_NewsClass", cai_NewsClass, strCond);
        }


        /// <summary>
        /// 删除资讯分类数据
        /// </summary>
        /// <param name="classID"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_NewsClass where ClassID = " + this.classID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }

        #endregion 方法
    }
}
