﻿/**********************************************************
 * 说明：在线订单类Order
 * 作者：chshnren1
 * 创建日期：10/11/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Order的摘要说明。
    /// </summary>
    public class Order
    {
        #region 属性

        public int orderID { get; set; }		        //在线订单ID
        public string orderSubject { get; set; }	    //订单主题
        public string orderDesc { get; set; }           //订单说明
        public string companyName { get; set; }         //单位
        public string manager { get; set; }             //负责人姓名
        public string address { get; set; }             //联系地址
        public string zipCode { get; set; }             //邮编
        public string tel { get; set; }                 //电话
        public string fax { get; set; }                 //Fax
        public string mobile { get; set; }              //Mobile
        public string webSite { get; set; }             //网址
        public string email { get; set; }               //E-mail
        public DateTime addTime { get; set; }          //增加时间

        public bool exist;		//是否存在标志

        #endregion 属性



        #region 方法

        /// <summary>
        /// 根据参数OrderID，获取详细信息
        /// </summary>
        /// <param name="OrderID">订单ID</param>
        public void LoadData(int orderID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select OrderID,OrderSubject,OrderDesc,CompanyName,Manager,Address,ZipCode,Tel,Fax,Mobile,WebSite,Email,AddTime From cai_Order where OrderID = "
                + Convert.ToInt32(orderID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.orderID = GetSafeData.ValidateDataRow_N(dr, "OrderID");
                this.orderSubject = GetSafeData.ValidateDataRow_S(dr, "OrderSubject");
                this.orderDesc = GetSafeData.ValidateDataRow_S(dr, "OrderDesc");
                this.companyName = GetSafeData.ValidateDataRow_S(dr, "CompanyName");
                this.manager = GetSafeData.ValidateDataRow_S(dr, "Manager");
                this.address = GetSafeData.ValidateDataRow_S(dr, "Address");
                this.zipCode = GetSafeData.ValidateDataRow_S(dr, "ZipCode");
                this.tel = GetSafeData.ValidateDataRow_S(dr, "Tel");
                this.fax = GetSafeData.ValidateDataRow_S(dr, "Fax");
                this.mobile = GetSafeData.ValidateDataRow_S(dr, "Mobile");
                this.webSite = GetSafeData.ValidateDataRow_S(dr, "WebSite");
                this.email = GetSafeData.ValidateDataRow_S(dr, "Email");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按ID排序,读取所有信息
        /// </summary>
        /// <return></return>
        public static DataView QueryOrder()
        {

            string strSql = "";
            strSql = "select OrderID,OrderSubject,CompanyName,Manager,Address,ZipCode,Tel,Fax,Mobile,WebSite,Email,AddTime From cai_Order order by OrderID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加订单
        /// </summary>
        /// <return></return>
        public void Add(Hashtable order)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_Order", order);
        }

        /// <summary>
        /// 修改订单内容
        /// </summary>
        /// <param name="Order"></param>
        public void Update(Hashtable order)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where OrderID = " + this.orderID;
            db.Update("cai_Order", order, strCond);
        }


        /// <summary>
        /// 删除订单内容
        /// </summary>
        /// <param name="Order"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_Order where OrderID = " + this.orderID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
