﻿/**********************************************************
 * 说明：图片分类PicClass
 * 作者：chshnren1
 * 创建日期：3/9/2012
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    ///PicClass 的摘要说明
    /// </summary>
    public class PicClass
    {
        #region 属性

        public int picClassID { get; set; }                //图片分类ID
        public int picClassSortID { get; set; }            //图片分类排序ID
        public string picClassName { get; set; }           //图片分类名称
        public string picClassNameBig5 { get; set; }       //图片分类名称Big5
        public string picClassNameEn { get; set; }         //图片分类名称En
        public string classPicPath { get; set; }           //工厂图片路径
        public string picSeoTitle { get; set; }            //seo
        public string picSeoKeywords { get; set; }         //seo
        public string picSeoDesc { get; set; }             //seo
        public string addWho { get; set; }                 //增加者
        private DateTime addTime { get; set; }             //增加时间
        public bool exist { get; set; }                    //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数picClassID，获取图片分类信息
        /// </summary>
        /// <param name="picClassID">图片分类ID</param>
        public void LoadData(int picClassID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select PicClassID,PicClassSortID,PicClassName,PicClassNameBig5,PicClassNameEn,ClassPicPath,PicSeoTitle,PicSeoKeywords,PicSeoDesc,AddWho,AddTime From cai_PicClass where PicClassID = "
                + Convert.ToInt32(picClassID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.picClassID = GetSafeData.ValidateDataRow_N(dr, "PicClassID");
                this.picClassSortID = GetSafeData.ValidateDataRow_N(dr, "PicClassSortID");
                this.picClassName = GetSafeData.ValidateDataRow_S(dr, "PicClassName");
                this.picClassNameBig5 = GetSafeData.ValidateDataRow_S(dr, "PicClassNameBig5");
                this.picClassNameEn = GetSafeData.ValidateDataRow_S(dr, "PicClassNameEn");
                this.classPicPath = GetSafeData.ValidateDataRow_S(dr, "ClassPicPath");
                this.picSeoTitle = GetSafeData.ValidateDataRow_S(dr, "PicSeoTitle");
                this.picSeoKeywords = GetSafeData.ValidateDataRow_S(dr, "PicSeoKeywords");
                this.picSeoDesc = GetSafeData.ValidateDataRow_S(dr, "PicSeoDesc");
                this.addWho = GetSafeData.ValidateDataRow_S(dr, "AddWho");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }


        /// <summary>
        /// 读取数据
        /// </summary>
        /// <return></return>
        public static DataView QueryPicClass(string strSql)
        {
            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加新的图片分类
        /// </summary>
        /// <return></return>
        public void Add(Hashtable cai_PicClass)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_PicClass", cai_PicClass);
        }

        /// <summary>
        /// 修改图片分类数据
        /// </summary>
        /// <param name="picClassID"></param>
        public void Update(Hashtable cai_PicClass)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where PicClassID = " + this.picClassID;
            db.Update("cai_PicClass", cai_PicClass, strCond);
        }


        /// <summary>
        /// 删除图片分类数据
        /// </summary>
        /// <param name="picClassID"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_PicClass where PicClassID = " + this.picClassID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }

        #endregion 方法
    }
}