﻿/**********************************************************
 * 说明：产品类Product1
 * 作者：chshnren1
 * 创建日期：9/29/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Admin 的摘要说明。
    /// </summary>
    public class Product1
    {
        #region 私有成员

        private int _productID;		        //产品ID
        private string _productName;		    //产品名称
        private string _productModel;		    //产品型号
        private int _classID;               //产品分类ID
        private string _picPathSmall;	    //小图路径
        private string _picPathBig;	        //大图路径
        private string _productContent;     //产品说明
        private DateTime _addTime;          //增加时间

        private bool _exist;		//是否存在标志

        #endregion 私有成员

        #region 属性

        public int ProductID
        {
            set
            {
                this._productID = value;
            }
            get
            {
                return this._productID;
            }
        }
        public string ProductName
        {
            set
            {
                this._productName = value;
            }
            get
            {
                return this._productName;
            }
        }
        public string ProductModel
        {
            set
            {
                this._productModel = value;
            }
            get
            {
                return this._productModel;
            }
        }
        public int ClassID
        {
            set
            {
                this._classID = value;
            }
            get
            {
                return this._classID;
            }
        }
        public string PicPathSmall
        {
            set
            {
                this._picPathSmall = value;
            }
            get
            {
                return this._picPathSmall;
            }
        }
        public string PicPathBig
        {
            set
            {
                this._picPathBig = value;
            }
            get
            {
                return this._picPathBig;
            }
        }
        public string ProductContent
        {
            set
            {
                this._productContent = value;
            }
            get
            {
                return this._productContent;
            }
        }
        public DateTime AddTime
        {
            set
            {
                this._addTime = value;
            }
            get
            {
                return this._addTime;
            }
        }
        public bool Exist
        {
            get
            {
                return this._exist;
            }
        }

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数ProductID，获取详细信息
        /// </summary>
        /// <param name="ProductID">产品ID</param>
        public void LoadData(int productID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select ProductID,ProductName,ProductModel,ClassID,PicPathSmall,PicPathBig,ProductContent,AddTime From cai_Product1 where ProductID = "
                + Convert.ToInt32(productID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this._productID = GetSafeData.ValidateDataRow_N(dr, "ProductID");
                this._productName = GetSafeData.ValidateDataRow_S(dr, "ProductName");
                this._productModel = GetSafeData.ValidateDataRow_S(dr, "ProductModel");
                this._classID = GetSafeData.ValidateDataRow_N(dr, "ClassID");
                this._picPathSmall = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall");
                this._picPathBig = GetSafeData.ValidateDataRow_S(dr, "PicPathBig");
                this._productContent = GetSafeData.ValidateDataRow_S(dr, "ProductContent");
                this._addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this._exist = true;
            }
            else
            {
                this._exist = false;
            }
        }

        /// <summary>
        /// 按产品ID排序,读取所有产品资料
        /// </summary>
        /// <return></return>
        public static DataView QueryProducts()
        {

            string strSql = "";
            //strSql = "select ProductID,ProductName,ProductModel,ClassID,PicPathSmall,PicPathBig,AddTime From cai_Product1 order by ProductID desc";
            strSql = "select P.ProductID,P.ProductName,P.ProductModel,P.ClassID,PC.ClassName,P.PicPathSmall,P.PicPathBig,P.AddTime from cai_ProductClass PC inner join cai_Product1 P on PC.ClassID=P.ClassID order by P.ProductID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 按产品ID排序,读取所有产品资料
        /// </summary>
        /// <return></return>
        public static DataView QueryProductsFilter(int classID)
        {

            string strSql = "";
            strSql = "select ProductID,ProductName,ProductModel,ClassID,PicPathSmall,PicPathBig,AddTime From cai_Product1 where ClassID=" + classID + " order by ProductID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 读取产品分类信息
        /// </summary>
        /// <return></return>
        public static DataView QueryProductClass()
        {

            string strSql = "";
            strSql = "select ClassID,ClassName from cai_ProductClass order by ClassSortID";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加产品
        /// </summary>
        /// <return></return>
        public void Add(Hashtable product1)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_Product1", product1);
        }

        /// <summary>
        /// 修改产品信息
        /// </summary>
        /// <param name="ModifyProduct1"></param>
        public void Update(Hashtable product1)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where ProductID = " + this._productID;
            db.Update("cai_Product1", product1, strCond);
        }


        /// <summary>
        /// 删除产品信息
        /// </summary>
        /// <param name="Product1"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_Product1 where ProductID = " + this._productID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }


        #endregion 方法
    }
}
