﻿/**********************************************************
 * 说明：产品分类ProductClass
 * 作者：chshnren1
 * 创建日期：9/30/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Guestbook的摘要说明。
    /// </summary>
    public class ProductClass
    {
        #region 私有成员

        private int _classID;		        //产品分类ClassID
        private string _className;	        //分类名称
        private string _classSortID;        //分类排序ID
        private DateTime _addTime;          //增加时间

        private bool _exist;		//是否存在标志

        #endregion 私有成员

        #region 属性

        public int ClassID
        {
            set
            {
                this._classID = value;
            }
            get
            {
                return this._classID;
            }
        }
        public string ClassName
        {
            set
            {
                this._className = value;
            }
            get
            {
                return this._className;
            }
        }
        public string ClassSortID
        {
            set
            {
                this._classSortID = value;
            }
            get
            {
                return this._classSortID;
            }
        }
        public DateTime AddTime
        {
            set
            {
                this._addTime = value;
            }
            get
            {
                return this._addTime;
            }
        }
        public bool Exist
        {
            get
            {
                return this._exist;
            }
        }

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数ClassID，获取详细信息
        /// </summary>
        /// <param name="ClassID">产品分类ID</param>
        public void LoadData(int classID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select ClassID,ClassName,ClassSortID,AddTime From cai_ProductClass where ClassID = "
                + Convert.ToInt32(classID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this._classID = GetSafeData.ValidateDataRow_N(dr, "ClassID");
                this._className = GetSafeData.ValidateDataRow_S(dr, "ClassName");
                this._classSortID = GetSafeData.ValidateDataRow_S(dr, "ClassSortID");
                this._addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this._exist = true;
            }
            else
            {
                this._exist = false;
            }
        }

        /// <summary>
        /// 按ClassSortID排序,读取所有分类信息
        /// </summary>
        /// <return></return>
        public static DataView QueryClassName()
        {

            string strSql = "";
            strSql = "select ClassID,ClassName,ClassSortID,AddTime From cai_ProductClass order by ClassSortID";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加产品分类
        /// </summary>
        /// <return></return>
        public void Add(Hashtable productClass)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_ProductClass", productClass);
        }

        /// <summary>
        /// 修改产品分类
        /// </summary>
        /// <param name="ProductClass"></param>
        public void Update(Hashtable productClass)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where ClassID = " + this._classID;
            db.Update("cai_ProductClass", productClass, strCond);
        }


        /// <summary>
        /// 删除产品分类
        /// </summary>
        /// <param name="Guestbook"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_ProductClass where ClassID = " + this._classID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
