﻿/**********************************************************
 * 说明：站点信息类SiteInfo
 * 作者：chshnren1
 * 创建日期：9/28/2008
 * 修改日期：3/8/2012
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// SiteInfo 的摘要说明。
    /// </summary>
    public class SiteInfo
    {
        #region 属性

        public int siteInfoID { get; set; }             //站点信息ID
        public int siteInfoClassID { get; set; }        //站点信息分类ID
        public string siteInfoTitle { get; set; }       //站点信息标题
        public string seoTitle { get; set; }            //seo
        public string seoKeywords { get; set; }         //seo
        public string seoDesc { get; set; }             //seo
        public string siteContent { get; set; }         //站点信息内容
        public int clickTimes { get; set; }             //站点信息点击次数
        public string author { get; set; }             //增加者
        private DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数siteInfoID，获取详细信息
        /// </summary>
        /// <param name="SiteInfoID">站点信息ID</param>
        public void LoadData(int siteInfoID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select SiteInfoID,SiteInfoClassID,SiteInfoTitle,SeoTitle,SeoKeywords,SeoDesc,SiteContent,ClickTimes,AddTime From cai_SiteInfo where SiteInfoID = "
                + Convert.ToInt32(siteInfoID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.siteInfoID = GetSafeData.ValidateDataRow_N(dr, "SiteInfoID");
                this.siteInfoClassID = GetSafeData.ValidateDataRow_N(dr, "SiteInfoClassID");
                this.siteInfoTitle = GetSafeData.ValidateDataRow_S(dr, "SiteInfoTitle");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.siteContent = GetSafeData.ValidateDataRow_S(dr, "SiteContent");
                this.clickTimes = GetSafeData.ValidateDataRow_N(dr, "ClickTimes");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按站点信息ID排序,读取所有站点信息
        /// </summary>
        /// <return></return>
        public static DataView QuerySiteInfo()
        {

            string strSql = "";
            strSql = "select SiteInfoID,SiteInfoTitle,SiteClassName,AddTime From cai_V_SiteInfo order by SiteInfoID desc";

            //绑定数据
            Database db=new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加站点信息
        /// </summary>
        /// <return></return>
        public void Add(Hashtable siteInfo)
        { 
            Database db=new Database();           //实例化一个Database类
            db.Insert("cai_SiteInfo",siteInfo);
        }

        /// <summary>
        /// 修改站点信息内容
        /// </summary>
        /// <param name="newSiteInfo"></param>
        public void Update(Hashtable newSiteInfo)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where SiteInfoID = " + this.siteInfoID;
            db.Update("cai_SiteInfo", newSiteInfo, strCond);
        }


        #endregion 方法
    }
}