﻿/**********************************************************
 * 说明：站点信息分类SiteInfoClass
 * 作者：chshnren1
 * 创建日期：3/8/2012
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// SiteInfoClass的摘要说明。
    /// </summary>
    public class SiteInfoClass
    {
        #region 属性

        public int siteInfoClassID { get; set; }        //站点信息分类ID
        public int languageVersion { get; set; }        //语言版本
        public int siteInfoSortID { get; set; }         //分类排序ID
        public string siteClassName { get; set; }       //站点信息分类名称
        public string seoTitle { get; set; }            //seo
        public string seoKeywords { get; set; }         //seo
        public string seoDesc { get; set; }             //seo
        private string addWho { get; set; }             //增加者
        private DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数siteInfoClassID，获取站点分类信息
        /// </summary>
        /// <param name="siteInfoClassID">站点信息分类ID</param>
        public void LoadData(int siteInfoClassID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select SiteInfoClassID,LanguageVersion,SiteInfoSortID,SiteClassName,SeoTitle,SeoKeywords,SeoDesc,AddWho,AddTime From cai_SiteInfoClass where SiteInfoClassID = "
                + Convert.ToInt32(siteInfoClassID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.siteInfoClassID = GetSafeData.ValidateDataRow_N(dr, "SiteInfoClassID");
                this.languageVersion = GetSafeData.ValidateDataRow_N(dr, "LanguageVersion");
                this.siteInfoSortID = GetSafeData.ValidateDataRow_N(dr, "SiteInfoSortID");
                this.siteClassName = GetSafeData.ValidateDataRow_S(dr, "SiteClassName");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.addWho = GetSafeData.ValidateDataRow_S(dr, "AddWho");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }


        /// <summary>
        /// 读取数据
        /// </summary>
        /// <return></return>
        public static DataView QuerySiteInfoClass(string strSql)
        {
            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加新的站点信息分类
        /// </summary>
        /// <return></return>
        public void Add(Hashtable cai_SiteInfoClass)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_SiteInfoClass", cai_SiteInfoClass);
        }

        /// <summary>
        /// 修改站点信息分类数据
        /// </summary>
        /// <param name="siteInfoClassID"></param>
        public void Update(Hashtable cai_SiteInfoClass)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where SiteInfoClassID = " + this.siteInfoClassID;
            db.Update("cai_SiteInfoClass", cai_SiteInfoClass, strCond);
        }


        /// <summary>
        /// 删除站点信息分类数据
        /// </summary>
        /// <param name="siteInfoClassID"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_SiteInfoClass where SiteInfoClassID = " + this.siteInfoClassID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }

        #endregion 方法
    }
}
