﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using EnterpriseNET.BusinessLogicLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

public partial class enet0769_admin_edit_majorclass : System.Web.UI.Page
{
    public string Action;

    protected void Page_Load(object sender, EventArgs e)
    {
        Action = Convert.ToString(Request.QueryString["Action"]);
        switch (Action)
        {
            case "EditMajorClass":
                if (!IsPostBack)
                    InitData();
                break;
            case "DeleteMajorClass":
                int majorID = Convert.ToInt32(Request.QueryString["MajorID"]);
                MajorClass majorClass = new MajorClass();

                majorClass.LoadData(majorID);
                majorClass.Delete();

                Response.Redirect("manage_majorclass.aspx");

                break;

            default:
                break;
        }
    }


    /// <summary>
    /// 初始化页面数据
    /// </summary>
    private void InitData()
    {
        int majorID = Convert.ToInt32(Request.QueryString["MajorID"]);
        MajorClass majorClass = new MajorClass();
        majorClass.LoadData(majorID);

        MajorName.Text = majorClass.majorName;
        //MajorNameEn.Text = majorClass.majorNameEn;
        SeoTitle.Text = majorClass.seoTitle;
        //SeoTitleEn.Text = majorClass.seoTitleEn;
        SeoKeywords.Text = majorClass.seoKeywords;
        //SeoKeywordsEn.Text = majorClass.seoKeywordsEn;
        SeoDesc.Text = majorClass.seoDesc;
        //SeoDescEn.Text = majorClass.seoDescEn;
        MajorSortID.Text = majorClass.majorSortID;

    }


    protected void Button1_Click(object sender, EventArgs e)
    {
        MajorClass majorClass = new MajorClass();
        majorClass.majorID = Convert.ToInt32(Request.QueryString["MajorID"]);

        Hashtable ht = new Hashtable();
        ht.Add("MajorName", SqlStringConstructor.GetQuotedString(MajorName.Text));
        //ht.Add("MajorNameEn", SqlStringConstructor.GetQuotedString(MajorNameEn.Text));
        ht.Add("SeoTitle", SqlStringConstructor.GetQuotedString(SeoTitle.Text));
        //ht.Add("SeoTitleEn", SqlStringConstructor.GetQuotedString(SeoTitleEn.Text));
        ht.Add("SeoKeywords", SqlStringConstructor.GetQuotedString(SeoKeywords.Text));
        //ht.Add("SeoKeywordsEn", SqlStringConstructor.GetQuotedString(SeoKeywordsEn.Text));
        ht.Add("SeoDesc", SqlStringConstructor.GetQuotedString(SeoDesc.Text));
        //ht.Add("SeoDescEn", SqlStringConstructor.GetQuotedString(SeoDescEn.Text));
        ht.Add("MajorSortID", SqlStringConstructor.GetQuotedString(MajorSortID.Text));

        majorClass.Update(ht);

        Page.Response.Redirect("manage_majorclass.aspx");
    }
}
