﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using EnterpriseNET.BusinessLogicLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

public partial class enet0769_admin_edit_subclass : System.Web.UI.Page
{
    public string Action;

    protected void Page_Load(object sender, EventArgs e)
    {
        Action = Convert.ToString(Request.QueryString["Action"]);
        switch (Action)
        {
            case "EditSubClass":
                if (!IsPostBack)
                    InitData();
                break;
            case "DeleteSubClass":
                int subID = Convert.ToInt32(Request.QueryString["SubID"]);
                SubClass subClass = new SubClass();

                subClass.LoadData(subID);
                subClass.Delete();

                Response.Redirect("manage_subclass.aspx");

                break;

            default:
                break;
        }
    }

    /// <summary>
    /// 初始化页面数据
    /// </summary>
    private void InitData()
    {
        //绑定数据产品大类
        DataView dv = MajorClass.QueryMajorClass();
        MajorID.DataValueField = dv.Table.Columns[0].Caption.ToString();
        MajorID.DataTextField = dv.Table.Columns[2].Caption.ToString();
        MajorID.DataSource = dv;
        MajorID.DataBind();

        int subID = Convert.ToInt32(Request.QueryString["SubID"]);
        SubClass subClass = new SubClass();
        subClass.LoadData(subID);

        MajorID.Text = subClass.majorID.ToString();
        SubName.Text = subClass.subName;
        //SubNameEn.Text = subClass.subNameEn;
        SeoTitle.Text = subClass.seoTitle;
        //SeoTitleEn.Text = subClass.seoTitleEn;
        SeoKeywords.Text = subClass.seoKeywords;
        //SeoKeywordsEn.Text = subClass.seoKeywordsEn;
        SeoDesc.Text = subClass.seoDesc;
        //SeoDescEn.Text = subClass.seoDescEn;
        SubSortID.Text = subClass.subSortID.ToString();

    }

    protected void Button1_Update_Click(object sender, EventArgs e)
    {
        SubClass subClass = new SubClass();
        subClass.subID = Convert.ToInt32(Request.QueryString["SubID"]);

        Hashtable ht = new Hashtable();
        ht.Add("SubName", SqlStringConstructor.GetQuotedString(SubName.Text));
        //ht.Add("SubNameEn", SqlStringConstructor.GetQuotedString(SubNameEn.Text));
        ht.Add("SubSortID", SqlStringConstructor.GetQuotedString(SubSortID.Text));
        ht.Add("SeoTitle", SqlStringConstructor.GetQuotedString(SeoTitle.Text));
        //ht.Add("SeoTitleEn", SqlStringConstructor.GetQuotedString(SeoTitleEn.Text));
        ht.Add("SeoKeywords", SqlStringConstructor.GetQuotedString(SeoKeywords.Text));
        //ht.Add("SeoKeywordsEn", SqlStringConstructor.GetQuotedString(SeoKeywordsEn.Text));
        ht.Add("SeoDesc", SqlStringConstructor.GetQuotedString(SeoDesc.Text));
        //ht.Add("SeoDescEn", SqlStringConstructor.GetQuotedString(SeoDescEn.Text));
        ht.Add("MajorID", SqlStringConstructor.GetQuotedString(MajorID.SelectedItem.Value));

        subClass.Update(ht);

        Page.Response.Redirect("manage_subclass.aspx");
    }
}
