﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="news.aspx.cs" Inherits="news" EnableViewState="false" %>
<%@ Register src="UserControls/top.ascx" tagname="top" tagprefix="uc1" %>
<%@ Register src="UserControls/right.ascx" tagname="right" tagprefix="uc3" %>
<%@ Register src="UserControls/bottom.ascx" tagname="bottom" tagprefix="uc4" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>

<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<meta name="renderer" content="webkit" />
<meta name="robots" content="index, follow" />
<title><%#SeoTitle%> - 数据线公司</title>
<meta name="keywords" content="<%#SeoKeywords%>" />
<meta name="description" content="<%#SeoDesc%>" />
<link rel="stylesheet" type="text/css" href="/skin/css/font-awesome.css" media="screen"/>
<link rel="stylesheet" type="text/css" href="/skin/css/bootstrap.min.css" media="screen"/>
<!--<link rel="stylesheet" type="text/css" href="/skin/css/jquery.bxslider.css" media="screen"/>-->
<link rel="stylesheet" type="text/css" href="/skin/css/owl.carousel.css" media="screen"/>
<link rel="stylesheet" type="text/css" href="/skin/css/owl.theme.css" media="screen"/>
<link rel="stylesheet" type="text/css" href="/skin/css/settings.css" media="screen"/>
<link rel="stylesheet" type="text/css" href="/skin/css/style-red.css" media="screen"/>
<link rel="stylesheet" type="text/css" href="/skin/css/tk.css" media="screen"/>
<script type="text/javascript" src="/skin/js/jquery.min.js"></script>
<script type="text/javascript" src="/skin/js/bootstrap.min.js"></script>
<script type="text/javascript" src="/skin/js/owl.carousel.min.js"></script>
<!-- HTML5 shim, for IE6-8 support of HTML5 elements. All other JS at the end of file. -->
<!--[if lt IE 9]>
<script src="/skin/js/html5.js"></script>
<script src="/skin/js/respond.min.js"></script>
<style>
	article,aside,dialog,footer,header,section,nav,figure,menu{display:block;padding:0;margin:0;}
</style>
<link rel="stylesheet" href="/skin/css/ie.css" type="text/css" media="screen"/>
<![endif]-->
<!--[if lte IE 9]>
<script src="/skin/js/jquery.placeholder.js"></script>
<script>
jQuery(document).ready(function($){
	$('input, textarea').placeholder();
});
</script>
<script type="text/javascript" src="/skin/js/pie.js"></script>
<script type="text/javascript">
jQuery(document).ready(function($){
	$('.indexci img').each(function() {
		PIE.attach(this);  
	});  
});
</script>
<![endif]-->
<!--[if (gte IE 6)&(lte IE 8)]>
  <script type="text/javascript" src="/skin/js/ie8-eventlistener.js"></script>
  <script type="text/javascript" src="/skin/js/selectivizr.js"></script>
  <script type="text/javascript" src="/skin/js/excanvas.compiled.js"></script>
<![endif]-->
</head>

<body>
    <form id="form1" runat="server">
        <div id="container">
    <uc1:top ID="top1" runat="server" />

    <div class="breadcrumb-wrapper">
  <div class="container">
    <div class="row">
      <div class="col-md-3 col-sm-4 bcid-cat"><%#ShowNewsClass%></div>
      <div class="col-md-9 col-sm-8 location"><i class="fa fa-map-marker"></i> &nbsp;<span>当前位置：<a href="/">首页</a> &gt; <a href="news__1.html">资讯中心</a><%#ShowNewsPath%></span></div>
    </div>
  </div>
</div>

<div class="page-container" id="innerpage-wrap">
  <div class="container">
    <div class="row">
      <div class="main col-md-9 inner-left" role="main">
        <article class="blog-wrap"> 
        
            <asp:Repeater ID="rp_NewsList" runat="server">
            <ItemTemplate> 

        <div class="blog-article hentry format-image">
            <figure> <a class="swipebox-x" href="/news_detail-<%#Eval("NewsID") %>.html"> <img class="img-responsive" alt="<%#Eval("NewsTitle") %>" src="../upimage/<%#Eval("PicPathSmall")%>"/> </a> </figure>
            <div class="entry-summary post-summary">
              <header class="entry-header">
                <h2 class="entry-title post-title"> <a href="/news_detail-<%#Eval("NewsID") %>.html" title="<%#Eval("NewsTitle") %>"><%#Eval("NewsTitle") %></a> </h2>
              </header>
              <div class="entry-meta post-meta">
                <ul>
                  <li class="entry-date date">
                    <time class="entry-date" datetime="<%#Eval("AddTime","{0:yyyy-MM-dd}") %>"><%#Eval("AddTime","{0:yyyy-MM-dd}") %></time>
                  </li>
                  <li class="tags"><a href="/news__1.html">新闻资讯</a></li>
                  <li class="byline author vcard">by <a href="javascript:void(0)" class="fn">admin</a> </li>
                </ul>
              </div>
              <div class="entry-content">
                <p><%#Eval("SeoDesc")%></p>
              </div>
              <a href="/news_detail-<%#Eval("NewsID") %>.html" class="read-more-link">查看详细</a> </div>
          </div>
          </ItemTemplate>
       </asp:Repeater>
          
           </article>
        <div class="pagination-wrap">
          <div id="pages">
            <div class="page"><webdiyer:AspNetPager ID="AspNetPager1" runat="server" AlwaysShow="True" CustomInfoHTML="共有  <b><font color='red'>%RecordCount%</font></b>  条记录 当前页<b><font color='red'>%CurrentPageIndex%</font>/%PageCount%</b>   次序 %StartRecordIndex%-%EndRecordIndex%"
                                        FirstPageText="首页" HorizontalAlign="right" 
            InputBoxStyle="width:19px" LastPageText="尾页"
                                        meta:resourceKey="AspNetPager1" 
            NextPageText="下一页" NumericButtonCount="5" OnPageChanged="AspNetPager1_PageChanged"
                                        PageSize="5" PrevPageText="上一页" 
            ShowCustomInfoSection="Left" Style="font-size: 12px"
                                        Width="98%" CustomInfoTextAlign="Left" 
            UrlPaging="True" EnableUrlRewriting="True" 
        UrlRewritePattern="news_%classid%_{0}.html">
                                    </webdiyer:AspNetPager>
</div>
          </div>
        </div>
      </div>
      
      <uc3:right ID="right1" runat="server" />

 </div>
  </div>
</div>
<div class="for-bottom-padding"></div>


    <uc4:bottom ID="bottom1" runat="server" />
    
    </form>
</body>
</html>
