﻿/**********************************************************
 * 说明：广告类Adv
 * 作者：chshnren1
 * 创建日期：9/1/2018
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Adv 的摘要说明。
    /// </summary>
    public class Adv
    {
        #region 属性

        public int advID { get; set; }                  //广告ID
        public int advSortID { get; set; }              //广告排名ID
        public int advClassID { get; set; }             //广告分类ID
        public string advName { get; set; }             //广告名称
        public string advPicUrl { get; set; }           //广告图
        public string linkUrl { get; set; }              //链接网址
        public DateTime addTime { get; set; }           //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数advID，获取详细信息
        /// </summary>
        /// <param name="AdvID">广告ID</param>
        public void LoadData(int advID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select AdvID,AdvSortID,AdvClassID,AdvName,AdvPicUrl,LinkUrl,AddTime From Cai_Adv where AdvID = "
                + Convert.ToInt32(advID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.advID = GetSafeData.ValidateDataRow_N(dr, "AdvID");
                this.advSortID = GetSafeData.ValidateDataRow_N(dr, "AdvSortID");
                this.advClassID = GetSafeData.ValidateDataRow_N(dr, "AdvClassID");
                this.advName = GetSafeData.ValidateDataRow_S(dr, "AdvName");
                this.advPicUrl = GetSafeData.ValidateDataRow_S(dr, "AdvPicUrl");
                this.linkUrl = GetSafeData.ValidateDataRow_S(dr, "LinkUrl");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按广告ID排序,读取所有广告信息
        /// </summary>
        /// <return></return>
        public static DataView QueryAdv(string strSql)
        {

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// advID
        /// </summary>
        /// <return></return>
        public static DataView QueryAdvFilter(int advID)
        {

            string strSql = "";
            strSql = "select AdvID,AdvSortID,AdvClassID,AdvName,AdvPicUrl,LinkUrl,AddTime From Cai_Adv where AdvID=" + advID + " order by AdvID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加广告
        /// </summary>
        /// <return></return>
        public void Add(Hashtable adv)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("Cai_Adv", adv);
        }

        /// <summary>
        /// 修改广告内容
        /// </summary>
        /// <param name="adv"></param>
        public void Update(Hashtable adv)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where AdvID = " + this.advID;
            db.Update("Cai_Adv", adv, strCond);
        }


        /// <summary>
        /// 删除广告内容
        /// </summary>
        /// <param name="adv"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from Cai_Adv where AdvID = " + this.advID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}