﻿/**********************************************************
 * 说明：广告分类AdvClass
 * 作者：chshnren1
 * 创建日期：9/1/2018
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// AdvClass的摘要说明。
    /// </summary>
    public class AdvClass
    {
        #region 属性

        public int advClassID { get; set; }             //广告分类ID
        public int advClassSortID { get; set; }         //广告分类排序ID
        public string advClassName { get; set; }        //广告分类名称
        private DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数advClassID，获取广告分类信息
        /// </summary>
        /// <param name="advClassID">广告分类ID</param>
        public void LoadData(int advClassID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select AdvClassID,AdvClassSortID,AdvClassName,AddTime From Cai_AdvClass where AdvClassID = "
                + Convert.ToInt32(advClassID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.advClassID = GetSafeData.ValidateDataRow_N(dr, "AdvClassID");
                this.advClassSortID = GetSafeData.ValidateDataRow_N(dr, "AdvClassSortID");
                this.advClassName = GetSafeData.ValidateDataRow_S(dr, "AdvClassName");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }


        /// <summary>
        /// 读取数据
        /// </summary>
        /// <return></return>
        public static DataView QueryAdvClass(string strSql)
        {
            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加新的广告分类
        /// </summary>
        /// <return></return>
        public void Add(Hashtable cai_AdvClass)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("Cai_AdvClass", cai_AdvClass);
        }

        /// <summary>
        /// 修改广告分类数据
        /// </summary>
        /// <param name="advClassID"></param>
        public void Update(Hashtable cai_AdvClass)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where AdvClassID = " + this.advClassID;
            db.Update("Cai_AdvClass", cai_AdvClass, strCond);
        }


        /// <summary>
        /// 删除广告分类数据
        /// </summary>
        /// <param name="advClassID"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from Cai_AdvClass where AdvClassID = " + this.advClassID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }

        #endregion 方法
    }
}
