﻿/**********************************************************
 * 说明：购物车类Cart2
 * 作者：chshnren1
 * 创建日期：10/29/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;
using System.Data.OleDb;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Admin 的摘要说明。
    /// </summary>
    public class Cart2
    {
        #region 私有成员

        private int _cartId;		        //购物篮ID
        private int _memberID;	        //会员ID
        private ArrayList _products = new ArrayList();		    //购物篮中的购物篮ID集合
        private ArrayList _amount = new ArrayList();		    //购物篮中购物篮的数量
        private DateTime _addTime;         //增加时间

        private bool _exist;		//是否存在标志

        #endregion 私有成员

        #region 属性

        public int CartID
        {
            set
            {
                this._cartId = value;
            }
            get
            {
                return this._cartId;
            }
        }
        public int MemberID
        {
            set
            {
                this._memberID = value;
            }
            get
            {
                return this._memberID;
            }
        }
        public ArrayList Products
        {
            set
            {
                this._products = value;
            }
            get
            {
                return this._products;
            }
        }
        public ArrayList Amount
        {
            set
            {
                this._amount = value;
            }
            get
            {
                return this._amount;
            }
        }
        public DateTime AddTime
        {
            set
            {
                this._addTime = value;
            }
            get
            {
                return this._addTime;
            }
        }
        public bool Exist
        {
            get
            {
                return this._exist;
            }
        }

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数memberID，获取购物篮详细信息
        /// </summary>
        /// <param name="memberID">会员ID</param>
        public void LoadData(int memberID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select CartID,MemberID,ProductID,Amount,AddTime from cai_Cart2 where MemberID = " + memberID;

            OleDbDataReader reader = db.GetDataReader(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员安全赋值
            while (reader.Read())
            {
                if (this._cartId == 0)
                {
                    this._cartId = GetSafeData.ValidateDataReader_N(reader, "CartId");
                    this._memberID = GetSafeData.ValidateDataReader_N(reader, "MemberID");
                }
                this._products.Add(GetSafeData.ValidateDataReader_N(reader, "ProductID"));
                this._amount.Add(GetSafeData.ValidateDataReader_N(reader, "Amount"));

                this._exist = true;
            }
            if (this._cartId == 0)
            {
                this._exist = false;
            }
        }


        /// <summary>
        /// 向数据库添加一个购物篮中的一种产品
        /// </summary>
        /// <param name="topicInfo">购物篮中的一种产品的信息哈希表</param>
        public void Add(Hashtable cartInfo)
        {
            Database db = new Database();		//实例化一个Database类
            db.Insert("cai_Cart2", cartInfo);	//利用Database类的Inser方法，插入数据
        }

        /// <summary>
        /// 修改购物篮中的一种产品内容
        /// </summary>
        /// <param name="newCartInfo">新的购物篮信息哈希表</param>
        /// <param name="condition">Update的Where子句</param>
        public void Update(Hashtable newCartInfo, int cartId)
        {
            Database db = new Database();
            string condition = "Where CartID = " + cartId.ToString();
            db.Update("cai_Cart2", newCartInfo, condition);
        }


        /// <summary>
        /// 删除整个购物篮
        /// </summary>
        public void Delete()
        {
            Database db = new Database();
            string strSql = "Delete From cai_Cart2 Where CartID = " + this._cartId;
            db.ExecuteSQL(strSql);
        }


        /// <summary>
        /// 删除购物篮种某种产品
        /// </summary>
        /// <param name="cartId">将要删除购物篮的项目编号</param>
        public void RemoveBook(int cartId)
        {
            Database db = new Database();
            string strSql = "Delete From cai_Cart2 Where cartId = " + cartId.ToString();
            db.ExecuteSQL(strSql);
        }

        /// <summary>
        /// 查询memberID的购物篮中的信息，并以DataTable返回
        /// </summary>
        /// <param name="memberID">用户编号</param>
        /// <returns>购物篮信息DataTable</returns>
        public static DataTable Query(int memberID)
        {
            string sql = "";
            sql = "select c2.CartID,c2.MemberID,c2.ProductID,p2.ProductName,c2.Amount from cai_Cart2 c2 inner join cai_Product2 p2 on c2.ProductID=p2.ProductID where c2.ShoppingState=0 and c2.MemberID=" + memberID;
            Database db = new Database();
            return db.GetDataTable(sql);
        }
        #endregion 方法
    }
}
