﻿/**********************************************************
 * 说明：代理加盟类JoinIn
 * 作者：chshnren1
 * 创建日期：10/11/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// JoinIn的摘要说明。
    /// </summary>
    public class JoinIn
    {
        #region 属性

        public int joinInID { get; set; }		        //代理加盟ID
        public string userName { get; set; }	        //用户名
        public string email { get; set; }               //E-mail
        public string mSN { get; set; }                 //MSN
        public string skype { get; set; }               //Skype
        public string companyName { get; set; }         //单位
        public string companyNum { get; set; }          //公司规模
        public string contactor { get; set; }           //联系人
        public string sex { get; set; }                 //Sex
        public string tel { get; set; }                 //电话
        public string fax { get; set; }                 //Fax
        public string address { get; set; }             //联系地址
        public string webSite { get; set; }             //网址
        public DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数JoinInID，获取详细信息
        /// </summary>
        /// <param name="JoinInID">代理加盟ID</param>
        public void LoadData(int joinInID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select JoinInID,UserName,Email,MSN,Skype,CompanyName,CompanyNum,Contactor,Sex,Tel,Fax,Address,WebSite,AddTime From cai_JoinIn where JoinInID = "
                + Convert.ToInt32(joinInID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.joinInID = GetSafeData.ValidateDataRow_N(dr, "JoinInID");
                this.userName = GetSafeData.ValidateDataRow_S(dr, "UserName");
                this.email = GetSafeData.ValidateDataRow_S(dr, "Email");
                this.mSN = GetSafeData.ValidateDataRow_S(dr, "MSN");
                this.skype = GetSafeData.ValidateDataRow_S(dr, "Skype");
                this.companyName = GetSafeData.ValidateDataRow_S(dr, "CompanyName");
                this.companyNum = GetSafeData.ValidateDataRow_S(dr, "CompanyNum");
                this.contactor = GetSafeData.ValidateDataRow_S(dr, "Contactor");
                this.sex = GetSafeData.ValidateDataRow_S(dr, "Sex");
                this.tel = GetSafeData.ValidateDataRow_S(dr, "Tel");
                this.fax = GetSafeData.ValidateDataRow_S(dr, "Fax");
                this.address = GetSafeData.ValidateDataRow_S(dr, "Address");
                this.webSite = GetSafeData.ValidateDataRow_S(dr, "WebSite");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按ID排序,读取所有信息
        /// </summary>
        /// <return></return>
        public static DataView QueryJoinIn()
        {

            string strSql = "";
            strSql = "select JoinInID,UserName,Email,MSN,Skype,CompanyName,CompanyNum,Contactor,Sex,Tel,Fax,Address,WebSite,AddTime From cai_JoinIn order by JoinInID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加代理加盟信息
        /// </summary>
        /// <return></return>
        public void Add(Hashtable joinIn)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_JoinIn", joinIn);
        }

        /// <summary>
        /// 修改代理加盟内容
        /// </summary>
        /// <param name="JoinIn"></param>
        public void Update(Hashtable joinIn)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where JoinInID = " + this.joinInID;
            db.Update("cai_JoinIn", joinIn, strCond);
        }


        /// <summary>
        /// 删除代理加盟内容
        /// </summary>
        /// <param name="JoinIn"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_JoinIn where JoinInID = " + this.joinInID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
