﻿/**********************************************************
 * 说明：产品大类MajorClass
 * 作者：chshnren1
 * 创建日期：9/30/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Guestbook的摘要说明。
    /// </summary>
    public class MajorClass
    {
        #region 属性

        public int majorID { get; set; }		        //大类ID
        public string majorSortID { get; set; }         //大类排序ID
        public string majorName { get; set; }	        //大类名称
        public string majorNameEn { get; set; }	        //大类名称en
        public string seoTitle { get; set; }            //seo
        public string seoTitleEn { get; set; }          //seoEn
        public string seoKeywords { get; set; }         //seo
        public string seoKeywordsEn { get; set; }       //seoEn
        public string seoDesc { get; set; }             //seo
        public string seoDescEn { get; set; }           //seo
        public DateTime addTime { get; set; }           //增加时间

        public bool exist;		//是否存在标志

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数MajorID，获取详细信息
        /// </summary>
        /// <param name="MajorID">产品大类ID</param>
        public void LoadData(int majorID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select MajorID,MajorSortID,MajorName,majorNameEn,SeoTitle,seoTitleEn,SeoKeywords,SeoKeywordsEn,SeoDesc,SeoDescEn,AddTime From cai_MajorClass where MajorID = "
                + Convert.ToInt32(majorID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.majorID = GetSafeData.ValidateDataRow_N(dr, "MajorID");
                this.majorSortID = GetSafeData.ValidateDataRow_S(dr, "MajorSortID");
                this.majorName = GetSafeData.ValidateDataRow_S(dr, "MajorName");
                this.majorNameEn = GetSafeData.ValidateDataRow_S(dr, "MajorNameEn");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoTitleEn = GetSafeData.ValidateDataRow_S(dr, "SeoTitleEn");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoKeywordsEn = GetSafeData.ValidateDataRow_S(dr, "SeoKeywordsEn");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.seoDescEn = GetSafeData.ValidateDataRow_S(dr, "SeoDescEn");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按MajorSortID排序,读取所有产品大类信息
        /// </summary>
        /// <return></return>
        public static DataView QueryMajorClass()
        {

            string strSql = "";
            strSql = "select MajorID,MajorSortID,MajorName,MajorNameEn,AddTime From cai_MajorClass order by MajorSortID";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 读取产品大类信息
        /// </summary>
        /// <return></return>
        public static DataView QueryMajorClass(string strSql)
        {
            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加产品大类
        /// </summary>
        /// <return></return>
        public void Add(Hashtable majorName)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_MajorClass", majorName);
        }

        /// <summary>
        /// 修改产品大类
        /// </summary>
        /// <param name="Update MajorName"></param>
        public void Update(Hashtable majorName)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where MajorID = " + this.majorID;
            db.Update("cai_MajorClass", majorName, strCond);
        }


        /// <summary>
        /// 删除产品大类
        /// </summary>
        /// <param name="Delete MajorName"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_MajorClass where MajorID = " + this.majorID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}

