﻿/**********************************************************
 * 说明：会员类Member
 * 作者：chshnren1
 * 创建日期：10/17/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// JoinIn的摘要说明。
    /// </summary>
    public class Member
    {
        #region 私有成员

        private int _memberID;		        //会员ID
        private string _memberAccount;	    //会员帐号
        private string _memberPassword;	    //会员密码
        private string _companyName;        //公司名称
        private string _address;            //联系地址
        private string _zipCode;            //邮政编码
        private string _contactor;          //联系人
        private string _contactorDuty;      //联系人职位
        private string _tel;                //电话
        private string _fax;                //Fax
        private string _mobile;             //Mobile
        private string _email;              //E-mail
        private string _webSite;            //公司网址
        private string _memberProfile;      //会员简介
        private int _checkState;            //审核状态
        private DateTime _addTime;          //增加时间

        private bool _exist;		//是否存在标志

        #endregion 私有成员

        #region 属性

        public int MemberID
        {
            set
            {
                this._memberID = value;
            }
            get
            {
                return this._memberID;
            }
        }
        public string MemberAccount
        {
            set
            {
                this._memberAccount = value;
            }
            get
            {
                return this._memberAccount;
            }
        }
        public string MemberPassword
        {
            set
            {
                this._memberPassword = value;
            }
            get
            {
                return this._memberPassword;
            }
        }
        public string CompanyName
        {
            set
            {
                this._companyName = value;
            }
            get
            {
                return this._companyName;
            }
        }
        public string Address
        {
            set
            {
                this._address = value;
            }
            get
            {
                return this._address;
            }
        }
        public string ZipCode
        {
            set
            {
                this._zipCode = value;
            }
            get
            {
                return this._zipCode;
            }
        }
        public string Contactor
        {
            set
            {
                this._contactor = value;
            }
            get
            {
                return this._contactor;
            }
        }
        public string ContactorDuty
        {
            set
            {
                this._contactorDuty = value;
            }
            get
            {
                return this._contactorDuty;
            }
        }
        public string Tel
        {
            set
            {
                this._tel = value;
            }
            get
            {
                return this._tel;
            }
        }
        public string Fax
        {
            set
            {
                this._fax = value;
            }
            get
            {
                return this._fax;
            }
        }
        public string Mobile
        {
            set
            {
                this._mobile = value;
            }
            get
            {
                return this._mobile;
            }
        }
        public string Email
        {
            set
            {
                this._email = value;
            }
            get
            {
                return this._email;
            }
        }
        public string WebSite
        {
            set
            {
                this._webSite = value;
            }
            get
            {
                return this._webSite;
            }
        }
        public string MemberProfile
        {
            set
            {
                this._memberProfile = value;
            }
            get
            {
                return this._memberProfile;
            }
        }
        public int CheckState
        {
            set
            {
                this._checkState = value;
            }
            get
            {
                return this._checkState;
            }
        }
        public DateTime AddTime
        {
            set
            {
                this._addTime = value;
            }
            get
            {
                return this._addTime;
            }
        }
        public bool Exist
        {
            get
            {
                return this._exist;
            }
        }

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数MemberID，获取详细信息
        /// </summary>
        /// <param name="MemberID">会员ID</param>
        public void LoadData(int memberID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select MemberID,MemberAccount,MemberPassword,CompanyName,Address,ZipCode,Contactor,ContactorDuty,Tel,Fax,Mobile,Email,WebSite,MemberProfile,CheckState,AddTime From cai_Members where MemberID = "
                + Convert.ToInt32(memberID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this._memberID = GetSafeData.ValidateDataRow_N(dr, "MemberID");
                this._memberAccount = GetSafeData.ValidateDataRow_S(dr, "MemberAccount");
                this._memberPassword = GetSafeData.ValidateDataRow_S(dr, "MemberPassword");
                this._companyName = GetSafeData.ValidateDataRow_S(dr, "CompanyName");
                this._address = GetSafeData.ValidateDataRow_S(dr, "Address");
                this._zipCode = GetSafeData.ValidateDataRow_S(dr, "ZipCode");
                this._contactor = GetSafeData.ValidateDataRow_S(dr, "Contactor");
                this._contactorDuty = GetSafeData.ValidateDataRow_S(dr, "ContactorDuty");
                this._tel = GetSafeData.ValidateDataRow_S(dr, "Tel");
                this._fax = GetSafeData.ValidateDataRow_S(dr, "Fax");
                this._mobile = GetSafeData.ValidateDataRow_S(dr, "Mobile");
                this._email = GetSafeData.ValidateDataRow_S(dr, "Email");
                this._webSite = GetSafeData.ValidateDataRow_S(dr, "WebSite");
                this._memberProfile = GetSafeData.ValidateDataRow_S(dr, "MemberProfile");
                this._checkState = GetSafeData.ValidateDataRow_N(dr, "CheckState");
                this._addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this._exist = true;
            }
            else
            {
                this._exist = false;
            }
        }

        /// <summary>
        /// 根据参数memberAccount，获取会员详细信息
        /// </summary>
        /// <param name="memberAccount">管理员登录名</param>
        public void LoadData(string memberAccount)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select MemberID,MemberAccount,MemberPassword,CompanyName,Address,ZipCode,Contactor,ContactorDuty,Tel,Fax,Mobile,Email,WebSite,MemberProfile,CheckState,AddTime From cai_Members where MemberAccount = "
                + SqlStringConstructor.GetQuotedString(memberAccount);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this._memberID = GetSafeData.ValidateDataRow_N(dr, "MemberID");
                this._memberAccount = GetSafeData.ValidateDataRow_S(dr, "MemberAccount");
                this._memberPassword = GetSafeData.ValidateDataRow_S(dr, "MemberPassword");
                this._companyName = GetSafeData.ValidateDataRow_S(dr, "CompanyName");
                this._address = GetSafeData.ValidateDataRow_S(dr, "Address");
                this._zipCode = GetSafeData.ValidateDataRow_S(dr, "ZipCode");
                this._contactor = GetSafeData.ValidateDataRow_S(dr, "Contactor");
                this._contactorDuty = GetSafeData.ValidateDataRow_S(dr, "ContactorDuty");
                this._tel = GetSafeData.ValidateDataRow_S(dr, "Tel");
                this._fax = GetSafeData.ValidateDataRow_S(dr, "Fax");
                this._mobile = GetSafeData.ValidateDataRow_S(dr, "Mobile");
                this._email = GetSafeData.ValidateDataRow_S(dr, "Email");
                this._webSite = GetSafeData.ValidateDataRow_S(dr, "WebSite");
                this._memberProfile = GetSafeData.ValidateDataRow_S(dr, "MemberProfile");
                this._checkState = GetSafeData.ValidateDataRow_N(dr, "CheckState");
                this._addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this._exist = true;
            }
            else
            {
                this._exist = false;
            }
        }

        /// <summary>
        /// 按ID排序,读取所有信息
        /// </summary>
        /// <return></return>
        public static DataView QueryMembers()
        {

            string strSql = "";
            strSql = "select MemberID,MemberAccount,MemberPassword,CompanyName,Address,ZipCode,Contactor,ContactorDuty,Tel,Fax,Mobile,Email,WebSite,CheckState,AddTime From cai_Members order by MemberID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加会员信息
        /// </summary>
        /// <return></return>
        public void Add(Hashtable members)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_Members", members);
        }

        /// <summary>
        /// 修改会员信息
        /// </summary>
        /// <param name="Members"></param>
        public void Update(Hashtable members)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where MemberID = " + this._memberID;
            db.Update("cai_Members", members, strCond);
        }

        /// <summary>
        /// 修改会员信息
        /// </summary>
        /// <param name="htMemberInfo">会员信息哈希表</param>
        public static void Update(Hashtable memberInfo, string where)
        {
            Database db = new Database();		            //实例化一个Database类
            db.Update("cai_Members", memberInfo, where);	//利用Database类的Update方法修改管理员数据
        }

        /// <summary>
        /// 删除会员信息
        /// </summary>
        /// <param name="JoinIn"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_Members where MemberID = " + this._memberID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
