﻿/**********************************************************
 * 说明：新闻类News
 * 作者：chshnren1
 * 创建日期：9/29/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// News 的摘要说明。
    /// </summary>
    public class News
    {
        #region 属性

        public int newsID { get; set; }                 //资讯ID
        public int classID { get; set; }                //资讯分类ID
        public string newsTitle { get; set; }           //资讯标题
        public string picPathSmall { get; set; }        //小图
        public string picPathBig { get; set; }          //大图
        public string seoTitle { get; set; }            //seo
        public string seoKeywords { get; set; }         //seo
        public string seoDesc { get; set; }             //seo
        public string newsContent { get; set; }         //资讯内容
        public int clickTimes { get; set; }             //资讯点击次数
        public string addWho { get; set; }             //增加者
        public DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数newsID，获取详细信息
        /// </summary>
        /// <param name="NewsID">新闻ID</param>
        public void LoadData(int newsID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select NewsID,ClassID,PicPathSmall,PicPathBig,NewsTitle,SEOTitle,SeoKeywords,SeoDesc,NewsContent,ClickTimes,AddWho,AddTime From cai_News where NewsID = "
                + Convert.ToInt32(newsID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.newsID = GetSafeData.ValidateDataRow_N(dr, "NewsID");
                this.classID = GetSafeData.ValidateDataRow_N(dr, "ClassID");
                this.newsTitle = GetSafeData.ValidateDataRow_S(dr, "NewsTitle");
                this.picPathSmall = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall");
                this.picPathBig = GetSafeData.ValidateDataRow_S(dr, "PicPathBig");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.newsContent = GetSafeData.ValidateDataRow_S(dr, "NewsContent");
                this.clickTimes = GetSafeData.ValidateDataRow_N(dr, "ClickTimes");
                this.addWho = GetSafeData.ValidateDataRow_S(dr, "AddWho");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按新闻信息ID排序,读取所有新闻信息
        /// </summary>
        /// <return></return>
        public static DataView QueryNews(string strSql)
        {

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// ClassID
        /// </summary>
        /// <return></return>
        public static DataView QueryNewsFilter(int classID)
        {

            string strSql = "";
            strSql = "select NewsID,ClassID,NewsTitle,PicPathSmall,PicPathBig,SEOTitle,SeoKeywords,SeoDesc,NewsContent,ClickTimes,AddWho,AddTime,ClassName From cai_V_News where ClassID=" + classID + " order by NewsID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加新闻
        /// </summary>
        /// <return></return>
        public void Add(Hashtable news)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_News", news);
        }

        /// <summary>
        /// 修改新闻内容
        /// </summary>
        /// <param name="news"></param>
        public void Update(Hashtable news)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where NewsID = " + this.newsID;
            db.Update("cai_News", news, strCond);
        }


        /// <summary>
        /// 删除新闻内容
        /// </summary>
        /// <param name="news"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_News where NewsID = " + this.newsID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}
