﻿/**********************************************************
 * 说明：产品类Product2
 * 作者：chshnren1
 * 创建日期：9/29/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Admin 的摘要说明。
    /// </summary>
    public class Product2
    {
        #region 属性

        public int productID { get; set; }		        //产品ID
        public string productName { get; set; }		    //产品名称
        public string productNameEn { get; set; }		//产品名称en
        public string productModel { get; set; }	    //产品型号
        public int majorID { get; set; }                //大类ID
        public int subID { get; set; }                  //小类ID
        public string seoTitle { get; set; }            //seo
        public string seoTitleEn { get; set; }          //seoEn
        public string seoKeywords { get; set; }         //seo
        public string seoKeywordsEn { get; set; }       //seoEn
        public string seoDesc { get; set; }             //seo
        public string seoDescEn { get; set; }           //seo
        public string picPathSmall { get; set; }	    //小图路径
        public string picPathBig { get; set; }	        //大图路径
        public string picPathSmall1 { get; set; }	    //小图路径
        public string picPathBig1 { get; set; }	        //大图路径
        public string picPathSmall2 { get; set; }	    //小图路径
        public string picPathBig2 { get; set; }	        //大图路径
        public string picPathSmall3 { get; set; }	    //小图路径
        public string picPathBig3 { get; set; }	        //大图路径
        public string picPathSmall4 { get; set; }	    //小图路径
        public string picPathBig4 { get; set; }	        //大图路径
        public string picPathSmall5 { get; set; }	    //小图路径
        public string picPathBig5 { get; set; }	        //大图路径
        public string productContent { get; set; }      //产品说明
        public string productContent1 { get; set; }     //产品说明1
        public string productContent2 { get; set; }     //产品说明2
        public string productContent3 { get; set; }     //产品说明3
        public string productContent4 { get; set; }     //产品说明4
        public string productContent5 { get; set; }     //产品说明5
        public string productContentEn { get; set; }    //产品说明en
        public string productContentEn1 { get; set; }   //产品说明en1
        public int isRecommended { get; set; }          //是否推荐
        public int homeOrder { get; set; }              //产品权重
        public DateTime addTime { get; set; }           //增加时间

        public bool exist;		//是否存在标志

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数ProductID，获取详细信息
        /// </summary>
        /// <param name="ProductID">产品ID</param>
        public void LoadData(int productID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select ProductID,ProductName,ProductNameEn,ProductModel,MajorID,SubID,SeoTitle,SeoTitleEn,SeoKeywords,SeoKeywordsEn,SeoDesc,SeoDescEn,PicPathSmall,PicPathBig,PicPathSmall1,PicPathBig1,PicPathSmall2,PicPathBig2,PicPathSmall3,PicPathBig3,PicPathSmall4,PicPathBig4,PicPathSmall5,PicPathBig5,ProductContent,ProductContent1,ProductContent2,ProductContent3,ProductContent4,ProductContent5,ProductContentEn,ProductContentEn1,IsRecommended,HomeOrder,AddTime From cai_Product2 where ProductID = "
                + Convert.ToInt32(productID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.productID = GetSafeData.ValidateDataRow_N(dr, "ProductID");
                this.productName = GetSafeData.ValidateDataRow_S(dr, "ProductName");
                this.productNameEn = GetSafeData.ValidateDataRow_S(dr, "ProductNameEn");
                this.productModel = GetSafeData.ValidateDataRow_S(dr, "ProductModel");
                this.majorID = GetSafeData.ValidateDataRow_N(dr, "MajorID");
                this.subID = GetSafeData.ValidateDataRow_N(dr, "SubID");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoTitleEn = GetSafeData.ValidateDataRow_S(dr, "SeoTitleEn");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoKeywordsEn = GetSafeData.ValidateDataRow_S(dr, "SeoKeywordsEn");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.seoDescEn = GetSafeData.ValidateDataRow_S(dr, "SeoDescEn");
                this.picPathSmall = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall");
                this.picPathBig = GetSafeData.ValidateDataRow_S(dr, "PicPathBig");
                this.picPathSmall1 = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall1");
                this.picPathBig1 = GetSafeData.ValidateDataRow_S(dr, "PicPathBig1");
                this.picPathSmall2 = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall2");
                this.picPathBig2 = GetSafeData.ValidateDataRow_S(dr, "PicPathBig2");
                this.picPathSmall3 = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall3");
                this.picPathBig3 = GetSafeData.ValidateDataRow_S(dr, "PicPathBig3");
                this.picPathSmall4 = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall4");
                this.picPathBig4 = GetSafeData.ValidateDataRow_S(dr, "PicPathBig4");
                this.picPathSmall5 = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall5");
                this.picPathBig5 = GetSafeData.ValidateDataRow_S(dr, "PicPathBig5");
                this.productContent = GetSafeData.ValidateDataRow_S(dr, "ProductContent");
                this.productContent1 = GetSafeData.ValidateDataRow_S(dr, "ProductContent1");
                this.productContent2 = GetSafeData.ValidateDataRow_S(dr, "ProductContent2");
                this.productContent3 = GetSafeData.ValidateDataRow_S(dr, "ProductContent3");
                this.productContent4 = GetSafeData.ValidateDataRow_S(dr, "ProductContent4");
                this.productContent5 = GetSafeData.ValidateDataRow_S(dr, "ProductContent5");
                this.productContentEn = GetSafeData.ValidateDataRow_S(dr, "ProductContentEn");
                this.productContentEn1 = GetSafeData.ValidateDataRow_S(dr, "ProductContentEn1");
                this.isRecommended = GetSafeData.ValidateDataRow_N(dr, "IsRecommended");
                this.homeOrder = GetSafeData.ValidateDataRow_N(dr, "HomeOrder");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按产品ID排序,读取所有产品资料
        /// </summary>
        /// <return></return>
        public static DataView QueryProducts(string strSql)
        {
            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 按产品ID排序,读取所有产品资料
        /// </summary>
        /// <return></return>
        public static DataView QueryProductsMajorIDFilter(int majorID)
        {

            string strSql = "";
            strSql = "select ProductID,ProductName,ProductNameEn,ProductModel,MajorID,SubID,PicPathSmall,PicPathBig,AddTime From cai_Product2 where MajorID=" + majorID + " order by ProductID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 按产品ID排序,读取所有产品资料
        /// </summary>
        /// <return></return>
        public static DataView QueryProductsSubIDFilter(int subID)
        {

            string strSql = "";
            strSql = "select ProductID,ProductName,ProductNameEn,ProductModel,MajorID,SubID,PicPathSmall,PicPathBig,AddTime From cai_Product2 where SubID=" + subID + " order by ProductID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 读取产品分类信息
        /// </summary>
        /// <return></return>
        public static DataView QueryProductMajorClass()
        {

            string strSql = "";
            strSql = "select MajorID,MajorName from cai_MajorClass order by MajorSortID";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加产品
        /// </summary>
        /// <return></return>
        public void Add(Hashtable product2)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_Product2", product2);
        }

        /// <summary>
        /// 修改产品信息
        /// </summary>
        /// <param name="UpdateProduct2"></param>
        public void Update(Hashtable product2)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where ProductID = " + this.productID;
            db.Update("cai_Product2", product2, strCond);
        }


        /// <summary>
        /// 删除产品信息
        /// </summary>
        /// <param name="DeleteProduct2"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_Product2 where ProductID = " + this.productID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }


        #endregion 方法
    }
}
