﻿/**********************************************************
 * 说明：工程案例类ProjectCase
 * 作者：chshnren1
 * 创建日期：9/29/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Admin 的摘要说明。
    /// </summary>
    public class ProjectCase
    {
        #region 私有成员

        private int _projectID;		        //工程案例ID
        private string _projectName;		//工程案例名称
        private string _picPathSmall;	    //小图路径
        private string _picPathBig;	        //大图路径
        private string _projectContent;     //工程案例说明
        private DateTime _addTime;          //增加时间

        private bool _exist;		//是否存在标志

        #endregion 私有成员

        #region 属性

        public int ProjectID
        {
            set
            {
                this._projectID = value;
            }
            get
            {
                return this._projectID;
            }
        }
        public string ProjectName
        {
            set
            {
                this._projectName = value;
            }
            get
            {
                return this._projectName;
            }
        }
        public string PicPathSmall
        {
            set
            {
                this._picPathSmall = value;
            }
            get
            {
                return this._picPathSmall;
            }
        }
        public string PicPathBig
        {
            set
            {
                this._picPathBig = value;
            }
            get
            {
                return this._picPathBig;
            }
        }
        public string ProjectContent
        {
            set
            {
                this._projectContent = value;
            }
            get
            {
                return this._projectContent;
            }
        }
        public DateTime AddTime
        {
            set
            {
                this._addTime = value;
            }
            get
            {
                return this._addTime;
            }
        }
        public bool Exist
        {
            get
            {
                return this._exist;
            }
        }

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数ProjectID，获取详细信息
        /// </summary>
        /// <param name="ProjectID">工程案例ID</param>
        public void LoadData(int projectID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select ProjectID,ProjectName,PicPathSmall,PicPathBig,ProjectContent,AddTime From cai_ProjectCase where ProjectID = "
                + Convert.ToInt32(projectID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this._projectID = GetSafeData.ValidateDataRow_N(dr, "ProjectID");
                this._projectName = GetSafeData.ValidateDataRow_S(dr, "ProjectName");
                this._picPathSmall = GetSafeData.ValidateDataRow_S(dr, "PicPathSmall");
                this._picPathBig = GetSafeData.ValidateDataRow_S(dr, "PicPathBig");
                this._projectContent = GetSafeData.ValidateDataRow_S(dr, "ProjectContent");
                this._addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this._exist = true;
            }
            else
            {
                this._exist = false;
            }
        }

        /// <summary>
        /// 按工程案例ID排序,读取所有工程案例
        /// </summary>
        /// <return></return>
        public static DataView QueryProjectCase()
        {

            string strSql = "";
            strSql = "select ProjectID,ProjectName,PicPathSmall,PicPathBig,AddTime From cai_ProjectCase order by ProjectID desc";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加工程案例
        /// </summary>
        /// <return></return>
        public void Add(Hashtable projectCase)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_ProjectCase", projectCase);
        }

        /// <summary>
        /// 修改工程案例
        /// </summary>
        /// <param name="ProjectCase"></param>
        public void Update(Hashtable projectCase)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where ProjectID = " + this._projectID;
            db.Update("cai_ProjectCase", projectCase, strCond);
        }


        /// <summary>
        /// 删除工程案例
        /// </summary>
        /// <param name="ProjectCase"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_ProjectCase where ProjectID = " + this._projectID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }


        #endregion 方法
    }
}
