﻿/**********************************************************
 * 说明：SEO类
 * 作者：chshnren1
 * 创建日期：8/31/2018
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// Seo的摘要说明。
    /// </summary>
    public class Seo
    {
        #region 属性

        public int seoID { get; set; }                  //SEO ID
        public int seoTypeID { get; set; }              //类型ID
        public string seoTitle { get; set; }            //Seo标题
        public string seoKeywords { get; set; }         //Seo关键词
        public string seoDesc { get; set; }             //Seo描述
        public DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数seoID，获取详细信息
        /// </summary>
        /// <param name="SeoID">SEO ID</param>
        public void LoadData(int seoID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select SeoID,SeoTypeID,SeoTitle,SeoKeywords,SeoDesc,AddTime From Cai_SEO where SeoID = "
                + Convert.ToInt32(seoID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.seoID = GetSafeData.ValidateDataRow_N(dr, "SeoID");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 修改SEO配置
        /// </summary>
        /// <param name="Cai_SEO"></param>
        public void Update(Hashtable seo)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where SeoID = " + this.seoID;
            db.Update("Cai_SEO", seo, strCond);
        }


        #endregion 方法
    }
}