﻿/**********************************************************
 * 说明：站点配置类SiteConfig
 * 作者：chshnren1
 * 创建日期：8/29/2018
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// SiteConfig 的摘要说明。
    /// </summary>
    public class SiteConfig
    {
        #region 属性

        public int siteConfigID { get; set; }           //站点配置ID
        public string companyName { get; set; }         //公司名称
        public string logoPicUrl { get; set; }          //logo图片
        public string logoAlt { get; set; }             //logo alt属性
        public string address { get; set; }             //公司地址
        public string tel { get; set; }                 //电话
        public string contacts { get; set; }            //联系人
        public string tel400 { get; set; }              //400电话
        public string mobile { get; set; }              //手机号码
        public string fax { get; set; }                 //传真
        public string email { get; set; }               //E-mail
        public string webSite { get; set; }             //网址
        public string recordNumber { get; set; }        //备案号码
        public string statistics { get; set; }          //统计代码
        public string siteProfile { get; set; }         //公司简介
        public DateTime addTime { get; set; }          //增加时间
        public bool exist { get; set; }                 //数据是否存在

        #endregion 属性

        #region 方法

        /// <summary>
        /// 根据参数siteConfigID，获取详细信息
        /// </summary>
        /// <param name="SiteConfigID">站点配置ID</param>
        public void LoadData(int siteConfigID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select siteConfigID,companyName,logoPicUrl,logoAlt,Address,tel,Contacts,Tel400,Mobile,fax,email,WebSite,RecordNumber,Statistics,siteProfile,addTime From Cai_SiteConfig where SiteConfigID = "
                + Convert.ToInt32(siteConfigID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.siteConfigID = GetSafeData.ValidateDataRow_N(dr, "SiteConfigID");
                this.companyName = GetSafeData.ValidateDataRow_S(dr, "CompanyName");
                this.logoPicUrl = GetSafeData.ValidateDataRow_S(dr, "LogoPicUrl");
                this.logoAlt = GetSafeData.ValidateDataRow_S(dr, "LogoAlt");
                this.address = GetSafeData.ValidateDataRow_S(dr, "Address");
                this.tel = GetSafeData.ValidateDataRow_S(dr, "Tel");
                this.contacts = GetSafeData.ValidateDataRow_S(dr, "Contacts");
                this.tel400 = GetSafeData.ValidateDataRow_S(dr, "Tel400");
                this.mobile = GetSafeData.ValidateDataRow_S(dr, "Mobile");
                this.fax = GetSafeData.ValidateDataRow_S(dr, "Fax");
                this.email = GetSafeData.ValidateDataRow_S(dr, "Email");
                this.webSite = GetSafeData.ValidateDataRow_S(dr, "WebSite");
                this.recordNumber = GetSafeData.ValidateDataRow_S(dr, "RecordNumber");
                this.statistics = GetSafeData.ValidateDataRow_S(dr, "Statistics");
                this.siteProfile = GetSafeData.ValidateDataRow_S(dr, "SiteProfile");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 修改站点配置
        /// </summary>
        /// <param name="news"></param>
        public void Update(Hashtable siteConfig)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where SiteConfigID = " + this.siteConfigID;
            db.Update("Cai_SiteConfig", siteConfig, strCond);
        }

      
        #endregion 方法
    }
}