﻿/**********************************************************
 * 说明：产品小类SubClass
 * 作者：chshnren1
 * 创建日期：9/30/2008
 * E-mail：chshnren@163.com
 *********************************************************/

using System;
using System.Collections;
using System.Data;

using EnterpriseNET.DataAccessLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

namespace EnterpriseNET.BusinessLogicLayer
{
    /// <summary>
    /// SubClass的摘要说明。
    /// </summary>
    public class SubClass
    {
        #region 私有成员

        public int subID { get; set; }              //小类ID
        public int subSortID { get; set; }          //小类排序ID
        public int majorID { get; set; }		    //大类ID
        public string majorName { get; set; }	    //大类名称
        public string majorNameEn { get; set; }	    //大类名称En
        public string subName { get; set; }	        //小类名称
        public string subNameEn { get; set; }	    //小类名称En
        public string seoTitle { get; set; }            //seo
        public string seoTitleEn { get; set; }          //seoEn
        public string seoKeywords { get; set; }         //seo
        public string seoKeywordsEn { get; set; }       //seoEn
        public string seoDesc { get; set; }             //seo
        public string seoDescEn { get; set; }           //seo
        public DateTime addTime { get; set; }       //增加时间

        public bool exist;		//是否存在标志

        #endregion 私有成员

        #region 方法

        /// <summary>
        /// 根据参数SubID，获取详细信息
        /// </summary>
        /// <param name="SubID">产品大类ID</param>
        public void LoadData(int subID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select SubID,SubSortID,MajorID,SubName,subNameEn,SeoTitle,seoTitleEn,SeoKeywords,seoKeywordsEn,SeoDesc,seoDescEn,AddTime From cai_SubClass where SubID = "
                + Convert.ToInt32(subID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.subID = GetSafeData.ValidateDataRow_N(dr, "SubID");
                this.subSortID = GetSafeData.ValidateDataRow_N(dr, "SubSortID");
                this.majorID = GetSafeData.ValidateDataRow_N(dr, "MajorID");
                this.subName = GetSafeData.ValidateDataRow_S(dr, "SubName");
                this.subNameEn = GetSafeData.ValidateDataRow_S(dr, "SubNameEn");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoTitleEn = GetSafeData.ValidateDataRow_S(dr, "SeoTitleEn");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoKeywordsEn = GetSafeData.ValidateDataRow_S(dr, "SeoKeywordsEn");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.seoDescEn = GetSafeData.ValidateDataRow_S(dr, "SeoDescEn");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 根据参数SubID，获取详细信息
        /// </summary>
        /// <param name="SubID">产品大类ID</param>
        public void LoadData1(int subID)
        {
            Database db = new Database();		//实例化一个Database类

            string sql = "";
            sql = "Select SubID,SubSortID,MajorID,MajorName,MajorNameEn,SubName,subNameEn,SeoTitle,seoTitleEn,SeoKeywords,seoKeywordsEn,SeoDesc,seoDescEn,AddTime From cai_V_Major_Sub_Class where SubID = "
                + Convert.ToInt32(subID);

            DataRow dr = db.GetDataRow(sql);	//利用Database类的GetDataRow方法查询用户数据

            //根据查询得到的数据，对成员赋值
            if (dr != null)
            {
                this.subID = GetSafeData.ValidateDataRow_N(dr, "SubID");
                this.subSortID = GetSafeData.ValidateDataRow_N(dr, "SubSortID");
                this.majorID = GetSafeData.ValidateDataRow_N(dr, "MajorID");
                this.subName = GetSafeData.ValidateDataRow_S(dr, "SubName");
                this.subNameEn = GetSafeData.ValidateDataRow_S(dr, "SubNameEn");
                this.majorName = GetSafeData.ValidateDataRow_S(dr, "MajorName");
                this.majorNameEn = GetSafeData.ValidateDataRow_S(dr, "MajorNameEn");
                this.seoTitle = GetSafeData.ValidateDataRow_S(dr, "SeoTitle");
                this.seoTitleEn = GetSafeData.ValidateDataRow_S(dr, "SeoTitleEn");
                this.seoKeywords = GetSafeData.ValidateDataRow_S(dr, "SeoKeywords");
                this.seoKeywordsEn = GetSafeData.ValidateDataRow_S(dr, "SeoKeywordsEn");
                this.seoDesc = GetSafeData.ValidateDataRow_S(dr, "SeoDesc");
                this.seoDescEn = GetSafeData.ValidateDataRow_S(dr, "SeoDescEn");
                this.addTime = GetSafeData.ValidateDataRow_T(dr, "AddTime");

                this.exist = true;
            }
            else
            {
                this.exist = false;
            }
        }

        /// <summary>
        /// 按SubSortID排序,读取所有产品小类信息
        /// </summary>
        /// <return></return>
        public static DataView QuerySubClass()
        {

            string strSql = "";
            strSql = "select SubID,SubSortID,MajorID,MajorName,SubName,SubNameEn,AddTime from cai_V_Major_Sub_Class order by MajorID,SubSortID";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 按SubSortID排序,读取所有产品小类信息
        /// </summary>
        /// <return></return>string strSql
        public static DataView QuerySubClass(int majorID)
        {

            string strSql = "";
            strSql = "select SubID,SubSortID,MajorID,SubName,SubNameEn,AddTime From cai_SubClass where MajorID= " + majorID + " order by SubSortID";

            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 读取产品小类信息
        /// </summary>
        /// <return></return>
        public static DataView QuerySubClass(string strSql)
        {
            //绑定数据
            Database db = new Database();
            return db.GetDataView(strSql);
        }

        /// <summary>
        /// 增加产品小类
        /// </summary>
        /// <return></return>
        public void Add(Hashtable subName)
        {
            Database db = new Database();           //实例化一个Database类
            db.Insert("cai_SubClass", subName);
        }

        /// <summary>
        /// 修改产品小类
        /// </summary>
        /// <param name="Update SubName"></param>
        public void Update(Hashtable subName)
        {
            Database db = new Database();           //实例化一个Database类
            string strCond = "where SubID = " + this.subID;
            db.Update("cai_SubClass", subName, strCond);
        }


        /// <summary>
        /// 删除产品小类
        /// </summary>
        /// <param name="Delete SubName"></param>
        public void Delete()
        {
            string sql = "";
            sql = "Delete from cai_SubClass where SubID = " + this.subID;

            Database db = new Database();
            db.ExecuteSQL(sql);
        }
        #endregion 方法
    }
}

