﻿using System;
using System.Data;
using System.IO;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using EnterpriseNET.BusinessLogicLayer;
using EnterpriseNET.DataAccessHelper;
using EnterpriseNET.CommonComponent;

public partial class enet0769_admin_edit_project_case : System.Web.UI.Page
{
    public string Action;
  
    protected void Page_Load(object sender, EventArgs e)
    {
        Action = Convert.ToString(Request.QueryString["Action"]);

        switch (Action)
        {
            case "EditProjectCase":
                if (!IsPostBack)
                    InitData();
                break;
            case "DeleteProjectCase":
                int projectID=Convert.ToInt32(Request.QueryString["ProjectID"]);
                ProjectCase projectCase = new ProjectCase();

                projectCase.LoadData(projectID);
                projectCase.Delete();

                Response.Redirect("manage_project_case.aspx");

                break;

            default:
                break;
        }
    }


    /// <summary>
    /// 初始化页面数据
    /// </summary>
    private void InitData()
    {
        int projectID = Convert.ToInt32(Request.QueryString["ProjectID"]);
        ProjectCase projectCase = new ProjectCase();
        projectCase.LoadData(projectID);

        ProjectName.Text = projectCase.ProjectName;
        if (projectCase.PicPathSmall != "" && projectCase.PicPathSmall != null && projectCase.PicPathSmall != "nopic1.jpg")
        {
            NewsPic.ImageUrl = "/upimage/" + projectCase.PicPathSmall;
        }
        else
        {
            NewsPic.Visible = false;
        }
        FCKeditor1.Value = projectCase.ProjectContent;

    }

    protected void btn_Update_Click(object sender, EventArgs e)
    {
        ProjectCase projectCase = new ProjectCase();
        projectCase.ProjectID = Convert.ToInt32(Request.QueryString["ProjectID"]);

        Hashtable ht = new Hashtable();
        ht.Add("ProjectName", SqlStringConstructor.GetQuotedString(ProjectName.Text));
        ht.Add("ProjectContent", SqlStringConstructor.GetQuotedString(FCKeditor1.Value));

        //附件名,以当前时间为文件名前缀,确保文件名没有重复
        string affixFileName = myfileAdd.Value.Trim();
        int ShowFileSize = Convert.ToInt32(myfileAdd.PostedFile.ContentLength.ToString()) / 1024;
        string ShowFileType = affixFileName.Substring(affixFileName.LastIndexOf(".") + 1).ToLower();
        int idx = affixFileName.LastIndexOf('\\');
        affixFileName = affixFileName.Substring(idx + 1);
        string fileName = "";
        if (affixFileName != "")
        {
            if (ShowFileType == "jpg" || ShowFileType == "swf" || ShowFileType == "gif" || ShowFileType == "bmp" || ShowFileType == "png" || ShowFileType == "xls" || ShowFileType == "xlsx" || ShowFileType == "doc" || ShowFileType == "docx" || ShowFileType == "pdf" || ShowFileType == "rar" || ShowFileType == "zip" || ShowFileType == "txt" || ShowFileType == "chm")
            {
                //Ticks属性的值为自 0001 年 1 月 1 日午夜 12:00 以来所经过时间以 100 毫微秒为间隔表示时的数字。
                //fileName = System.DateTime.Now.Ticks.ToString() + affixFileName;
                //fileName = affixFileName;
                fileName = System.DateTime.Now.Ticks.ToString() + "." + ShowFileType;
                ht.Add("PicPathBig", SqlStringConstructor.GetQuotedString(fileName));
                //ht.Add("FileSize", SqlStringConstructor.GetQuotedString(Convert.ToString(ShowFileSize)));
                //ht.Add("FileType", SqlStringConstructor.GetQuotedString(ShowFileType));

                myfileAdd.PostedFile.SaveAs(Server.MapPath("~//upimage//affix//") + fileName);


            }
            else
            {
                Response.Write("<Script Language=JavaScript>alert(\"该文件不允许上传！\")</Script>");
            }
        }
        else
        {
            //Response.Write("<Script Language=JavaScript>alert(\"请选择上传文件！\")</Script>");
        }

        projectCase.Update(ht);
        Response.Redirect("manage_project_case.aspx");
    }

   
}
