﻿<%@ Application Language="C#" %>
<%@ Import Namespace="System.Web.Routing" %>
<%@ Import Namespace="System.ServiceModel.Activation" %>
<%@ Import Namespace="System.ServiceModel.Web" %>

<script RunAt="server">

    void Application_Start(object sender, EventArgs e)
    {
        RegisterRoutes(RouteTable.Routes);
    }

    void RegisterRoutes(RouteCollection routes)
    {
        routes.MapPageRoute("shopList", "shop/{cID}.htm", "~/shop/default.aspx", true);
        routes.MapPageRoute("shopShow", "{cID}.htm", "~/shop/show.aspx", true);
        routes.MapPageRoute("top", "top/{cID}.htm", "~/top/list.aspx", true);
        routes.MapPageRoute("coupon", "coupon/{cID}.htm", "~/coupon/default.aspx", true);

        routes.MapPageRoute("list", "item/{cID}.htm", "~/item/list.aspx", true);
        routes.MapPageRoute("show", "show/{sID}.htm", "~/item/show.aspx", true);
        routes.MapPageRoute("showM", "m/show/{sID}.htm", "~/m/item/show.aspx", true);
        
        routes.MapPageRoute("articleList", "article/{cID}.htm", "~/article/list.aspx", true);
        routes.MapPageRoute("articleShow", "article/view/{sID}.htm", "~/article/show.aspx", true);
    }

    void Application_Error(object sender, EventArgs e)
    {
        int errorCode = 0;
        Exception ex = Server.GetLastError();

        if (ex is HttpException)
        {
            errorCode = ((HttpException)(ex)).GetHttpCode();
        }

        // 在出现未处理的错误时运行的代码
        string url = Request.Url.ToString();
        ex = Server.GetLastError().GetBaseException();
        StringBuilder str = new StringBuilder();
        str.Append("发生时间：" + DateTime.Now.ToString("yyyy.MM.dd HH:mm:ss"));

        string ip = "";
        if (Request.ServerVariables.Get("HTTP_X_FORWARDED_FOR") != null)
        {
            ip = Request.ServerVariables.Get("HTTP_X_FORWARDED_FOR").ToString().Trim();
        }
        else
        {
            ip = Request.ServerVariables.Get("Remote_Addr").ToString().Trim();
        }
        str.Append("\r\nIp地址：" + ip);
        str.Append("\r\n浏览器：" + Request.Browser.Browser.ToString() + "  " + Request.Browser.MajorVersion.ToString());
        str.Append("\r\n操作系统：" + Request.Browser.Platform.ToString());
        str.Append("\r\n出错页面：" + url);
        str.Append("\r\n错误信息：【" + errorCode.ToString() + "】 " + ex.Message);
        str.Append("\r\n错误源：" + ex.Source);
        str.Append("\r\n异常方法：" + ex.TargetSite);
        str.Append("\r\n堆栈信息：" + ex.StackTrace);
        str.Append("\r\n\r\n--------------------------------------------------------------------------------------------------\r\n\r\n");
        //创建路径 
        string upLoadPath = Server.MapPath("~/logFiles/");
        if (!System.IO.Directory.Exists(upLoadPath))
        {
            System.IO.Directory.CreateDirectory(upLoadPath);
        }
        //创建文件 写入错误 
        System.IO.File.AppendAllText(upLoadPath + DateTime.Now.ToString("yyyyMMdd") + ".log", str.ToString(), System.Text.Encoding.UTF8);
        //处理完及时清理异常 
        Server.ClearError();
        //跳转至出错页面

        if (errorCode == 404)
        {
            Response.Redirect("/inClude/error.aspx?url=" + url, true);
            Response.End();
        }
        else
        {
            Response.Write("错误信息：【" + errorCode.ToString() + "】 " + ex.Message);
            Response.End();
        }
    }
</script>