﻿<%@ OutputCache Duration="3600" VaryByParam="page" %>

<%@ Page Language="C#" AutoEventWireup="true" CodeFile="list.aspx.cs" Inherits="article_list" %>

<%@ Register Src="../inClude/head.ascx" TagName="head" TagPrefix="uc1" %>
<%@ Register Src="../inClude/bottom.ascx" TagName="bottom" TagPrefix="uc2" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title></title>
    <link href="../inClude/style.css" rel="stylesheet" type="text/css" />
    <link rel="shortcut icon" href="/images/favicon.ico" type="image/x-icon" />
    <script src="/js/jquery.min.js" type="text/javascript" charset="utf-8"></script>
    <script src="/js/all.js" type="text/javascript" charset="utf-8"></script>
</head>
<body>
    <form id="form1" runat="server">
        <uc1:head ID="head1" runat="server" />
        <div style="background-color: white; width: 100%;">
            <div class="divWidth" style="height: 50px; line-height: 50px;">
                <div class="divLeft">
                    <asp:Literal ID="navClass" runat="server" ViewStateMode="Disabled"></asp:Literal>
                </div>

                <div class="divRight">
                    <table class="navClassTable" align="right">
                        <tr>
                            <asp:Literal ID="classTD" runat="server" ViewStateMode="Disabled"></asp:Literal>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <div class="height15px"></div>
        <div class="divWidth">
            <div class="divLeft" style="width: 825px; background-color: white;">
                <div style="padding: 15px 20px 10px 20px;">
                    <div style="line-height: 22px; text-align:right;">
                        <asp:Repeater ID="navList" runat="server">
                            <ItemTemplate><a id="class<%# Eval("Tid").ToString().Trim() %>" href="/article/<%# Eval("Tid").ToString().Trim() %>.htm" target="_top" class="webClassSmall"><%# Eval("TreeName").ToString().Trim() %></a>&nbsp;&nbsp;&nbsp;</ItemTemplate>
                        </asp:Repeater>
                    </div>
                    <div class="hrLine"></div>
                    <div>
                        <asp:Repeater ID="RepeaterListNews" runat="server" ViewStateMode="Disabled">
                            <ItemTemplate>
                                <div style="background-color: white;">
                                    <table class="normalTable">
                                        <tr>
                                            <td style="padding: 5px 10px 5px 0; vertical-align: middle;"><div style="text-align: center; height: 120px; overflow: hidden;"><a href="/article/view/<%# Eval("Nid").ToString() %>.htm" target="_blank">
                                                <img style="width: 180px;" lay-src="<%# pic(Eval("upPreImg").ToString()) %>.300.jpg" /></a></div></td>
                                            <td>
                                                <ul>
                                                    <li style="white-space: nowrap; overflow:hidden;"><asp:HyperLink Font-Bold="true" ViewStateMode="Disabled" ID="showLink" CssClass="webClassSmall" Target="_blank" runat="server" NavigateUrl='<%# Eval("Nid","/article/view/{0}.htm") %>'><%# Eval("NewTitle").ToString().Trim() %></asp:HyperLink></li>
                                                    <li class="height10px"></li>
                                                    <li class="read12" style="height:66px; overflow: hidden;"><a href="/article/view/<%# Eval("Nid").ToString() %>.htm" target="_blank"><%# cut(Eval("NewContent").ToString(),144) %>...</a></li>
                                                    <li class="height5px"></li>
                                                    <li class="newsListDate">时间：<%# Convert.ToDateTime(Eval("postDate").ToString().Trim()).ToString("yyyy-MM-dd") %>&nbsp;&nbsp;&nbsp;<%# !string.IsNullOrWhiteSpace(Eval("newsFrom").ToString().Trim())?"出处："+Eval("newsFrom").ToString().Trim()+"&nbsp;&nbsp;&nbsp;":"" %>阅读数：<%# Eval("ReadNums").ToString() %></li>
                                                </ul>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="hrLinePoint"></div>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>
                    <div id="errDiv" runat="server">
                        <div style="text-align: center; height: 830px; line-height: 830px; font-size: 20px;">
                            <asp:Label ID="errInfo" runat="server" ViewStateMode="Disabled" ForeColor="#FF3300"></asp:Label>
                        </div>
                    </div>
                    <div id="pageDiv" runat="server" style="text-align: center; padding:5px 0 5px 0;">
                        <asp:Label ID="lblCurrentPage" runat="server" ViewStateMode="Disabled"></asp:Label>
                    </div>
                </div>
            </div>

            <div class="divRight" style="min-height:830px;">
                <div id="newsRightPOP" style="width: 360px;">
                    <asp:Literal ID="ad360" runat="server" ViewStateMode="Disabled"></asp:Literal>
                    <div class="bigTitle">月排行榜</div>
                    <div style="height: 2px; background-color: #fb3434;"></div>
                    <asp:Repeater ID="newsTOP" runat="server" ViewStateMode="Disabled">
                        <ItemTemplate>
                            <div style="background-color: white;">
                                <table style="width: 100%;" class="normalTable">
                                    <tr>
                                        <td style="padding: 5px 0 5px 5px; vertical-align: middle;"><div style="text-align: center; height: 70px; overflow: hidden;"><a title="<%# Eval("NewTitle").ToString() %>" href="/article/view/<%# Eval("Nid").ToString() %>.htm" target="_blank"><img style="width: 120px;" src="<%# pic(Eval("upPreImg").ToString()) %>.300.jpg" /></a></div></td>
                                        <td style="width:8px;"></td>
                                        <td>
                                            <ul style="width: 225px; overflow: hidden;">
                                                <li style="overflow:hidden; word-break:break-all; white-space:nowrap;"><a class="classID" href="/article/view/<%# Eval("Nid").ToString() %>.htm" target="_blank" title="<%# Eval("NewTitle").ToString().Trim() %>"><%# cut(Eval("NewTitle").ToString().Trim(),14) %></a></li>
                                                <li class="height5px"></li>
                                                <li class="read12" style="height: 48px; padding-right: 5px; overflow:hidden;"><a title="<%# Eval("NewTitle").ToString() %>" href="/article/view/<%# Eval("Nid").ToString() %>.htm" target="_blank"><%# cut(Eval("NewContent").ToString(),35) %>...</a></li>
                                            </ul>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div style="height: 3px;"></div>
                        </ItemTemplate>
                    </asp:Repeater>
                </div>
            </div>
        </div>
        <uc2:bottom ID="bottom1" runat="server" />
    </form>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#class<%=_css%>").css({ "color": "red", "font-weight": "bold" });

            layui.use('flow', function () {
                var flow = layui.flow;
                flow.lazyimg();
            });
        });

        (function ($) {
            var ieRight = ($(window).width() - $("#newsRightPOP").outerWidth(true) - 840) / 2;
            $(window).scroll(function () {
                var sc = $(window).scrollTop();
                if (sc > 252 && $(window).height() > 830) {                    
                    $("#newsRightPOP").css("right", ieRight + "px");
                    $("#newsRightPOP").css("top", "0px");
                    $("#newsRightPOP").css("position", "fixed");
                }
                else {
                    $("#newsRightPOP").css("top", "252px");
                    $("#newsRightPOP")("position", null);
                }
            })
        })(jQuery);
    </script>
</body>
</html>
