﻿using System;
using System.Data;
using System.Drawing;
using xabaraCOM;
public partial class inClude_head : System.Web.UI.UserControl
{
    public string _css = string.Empty;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            sqlServer s = new sqlServer();
            string _word = s.sqlVerifyString(Request.QueryString["word"]);
            if(!string.IsNullOrWhiteSpace(_word))
            {
                searchWord.Text = _word;
                searchWord.CssClass = "searchHeadHui";
            }
            else
            {
                searchWord.Text = "输入关键词或品牌";
                searchWord.CssClass = "searchHeadHui";
            }

            string _url = Server.UrlDecode(url.currently);

            if (_url.IndexOf("/article/") > -1)
            {
                _css = "article";
            }

            if (_url.IndexOf("/top/") > -1)
            {
                _css = "top";
            }

            if (_url.IndexOf("/coupon/") > -1)
            {
                _css = "coupon";

                searchType.Items.FindByValue("coupon").Selected = true;
                if (string.IsNullOrWhiteSpace(_word))
                {
                    searchWord.Text = "输入品牌或店铺全称";
                }
                searchWord.CssClass = "searchHeadHui";
            }

            if (_url.IndexOf("/shop/") > -1)
            {
                _css = "shop";
            }

            if (string.IsNullOrWhiteSpace(_css as string))
            {
                _css = url.lastAspxCss;
                if (xabara.isNum(_css.Substring(1, 1)) > 0 || (_css != "_default" && _css.Substring(0, 1) == "_")) //品牌数字或英文页
                {
                    _css = "shop";
                }
                else
                {
                    if (_css.IndexOf("item_") > -1 || _css.IndexOf("show_") > -1)   //商品列表
                    {
                        _css = "items";
                    }
                }
            }

            //Response.Write(_css);
            
            DataTable dt = s.getDataTable("select top 10 treeID,ppID,keywords from keywordid where isBad=0 and isPP=2 order by newID()");
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                _word = dt.Rows[i]["keywords"].ToString().Trim();
                adTxt.Text += "<a href=\"/item/"+ dt.Rows[i]["treeID"].ToString().Trim() + "-" + dt.Rows[i]["ppID"].ToString().Trim() + "-1.htm?word=" + Server.UrlEncode(_word) + "\" target=\"_blank\">" + _word + "</a>&nbsp;<span class=\"headLine\">|</span>&nbsp;";
            }
            dt.Dispose();

            dayTime.Text = datetime.cnTime(1, 1, 1);

            webName.Text = xml.read("xabara.config", "webName", 60) + xml.read("xabara.config", "titleMeta", 60);
        }
    }

    public string getRandomColor()
    {
        Random randomNum_1 = new Random(Guid.NewGuid().GetHashCode());
        System.Threading.Thread.Sleep(randomNum_1.Next(1));
        int int_Red = randomNum_1.Next(255);

        Random randomNum_2 = new Random((int)DateTime.Now.Ticks);
        int int_Green = randomNum_2.Next(255);

        Random randomNum_3 = new Random(Guid.NewGuid().GetHashCode());

        int int_Blue = randomNum_3.Next(255);
        int_Blue = (int_Red + int_Green > 380) ? int_Red + int_Green - 380 : int_Blue;
        int_Blue = (int_Blue > 255) ? 255 : int_Blue;
        Color color = Color.FromArgb(int_Red, int_Green, int_Blue);

        color = getDarkerColor(color);
        string strColor = "#" + Convert.ToString(color.ToArgb(), 16).PadLeft(8, '0').Substring(2, 6);
        return strColor;
    }

    //获取加深颜色
    public static Color getDarkerColor(Color color)
    {
        const int max = 255;
        int increase = new Random(Guid.NewGuid().GetHashCode()).Next(10, 255); //还可以根据需要调整此处的值

        int r = Math.Abs(Math.Min(color.R - increase, max));
        int g = Math.Abs(Math.Min(color.G - increase, max));
        int b = Math.Abs(Math.Min(color.B - increase, max));

        return Color.FromArgb(r, g, b);
    }
}