﻿using System;
using System.Web.UI;
using System.Data;
using xabaraCOM;
using Top.Api;
using Top.Api.Request;
using Top.Api.Response;
public partial class item_show : System.Web.UI.Page
{
    public string mmPid = string.Empty;
    public string appkey = string.Empty;
    protected void Page_Load(object sender, EventArgs e)
    {
        string classNav = "乡巴佬CMS_xabara.com";
        string titleStr = "乡巴佬CMS_xabara.com";
        string _nick = string.Empty;

        if (!IsPostBack)
        {
            appkey = xml.read("xabara.config", "appkey", 60);
            mmPid = xml.read("xabara.config", "itemPID", 60);

            xabara x = new xabara();
            sqlServer s = new sqlServer();
            classify c = new classify();
            fileDocument f = new fileDocument();
            DataTable dt;

            long id = xabara.isNum(Request.QueryString["id"]);
            if (id < 1)
            {
                object urlID = Page.RouteData.Values["sID"];
                if (!string.IsNullOrWhiteSpace(urlID as string))
                {
                    string _urlID = urlID.ToString().Replace(".htm", "");
                    id = xabara.isNum(_urlID);
                }
            }

            //读取信息
            long cidTemp = 0;
            string _ppName = string.Empty;
            string _seller_id = string.Empty;
            string _keywordID = "0";

            if (id > 0)
            {
                string strSql = "select coupon.couponMoney,coupon.coupon_remain_count,coupon.coupon_info,coupon.coupon_start_time,coupon.coupon_end_time,coupon.coupon_click_url,t.* from (select newstree.TreeName,newstree.treeNameTxt,keywordID.wordEN,keywordID.wordName,keywordID.logo,keywordID.bigPic,taobaoke.keywordID,taobaoke.title,taobaoke.classID,taobaoke.item_url,taobaoke.seller_id,taobaoke.pic_url,taobaoke.small_images,taobaoke.reserve_price,taobaoke.zk_final_price,taobaoke.volume,taobaoke.nick,taobaoke.provcity from taobaoke left join newstree on taobaoke.classID=newstree.Tid left join keywordID on taobaoke.keywordID=keywordID.id where taobaoke.num_iid=" + id.ToString() + ") as t left join coupon on coupon.seller_id=t.seller_id and coupon.couponMaxMoney<=t.zk_final_price order by couponMoney desc";
                dt = s.getDataTable(strSql);
                
                if (dt.Rows.Count > 0)
                {
                    string _logo = dt.Rows[0]["logo"].ToString().Trim();
                    _ppName = dt.Rows[0]["wordName"].ToString().Trim();
                    _nick = dt.Rows[0]["nick"].ToString().Trim();
                    if (string.IsNullOrWhiteSpace(_nick))
                    {
                        _nick = _ppName + "混合专卖店";
                    }                   
                    _seller_id = dt.Rows[0]["seller_id"].ToString().Trim();
                    _keywordID = dt.Rows[0]["keywordID"].ToString().Trim();

                    if (xabara.isNum(_seller_id) > 0)
                    {
                        shop.Text = "<li>店铺：<a target=\"_blank\" biz-sellerid=\"" + _seller_id + "\" isconvert=1 href=\"https://store.taobao.com/shop/view_shop.htm?user_number_id=" + _seller_id + "\" style=\"font-size:14px; color:#000;\">" + _nick + "</a></li>";
                    }

                    if (dt.Rows[0]["bigPic"].ToString().Trim() != "")
                    {
                        shopInfo.Text = "<div style=\"color:red; text-align:right; font-size:14px; padding-bottom:15px;\">淘优惠：<a class=\"classID\" target=\"_blank\" href=\"/" + dt.Rows[0]["wordEN"].ToString().Trim() + ".htm\">进入" + _ppName + "品牌特卖专题</a></div>";
                        shopInfo2.Text = "淘优惠：<a target=\"_blank\" href=\"/" + dt.Rows[0]["wordEN"].ToString().Trim() + ".htm\">进入" + _ppName + "品牌特卖专题</a>";

                        pp.Text = "<li>品牌：<a class=\"classID\" target=\"_blank\" href=\"/" + dt.Rows[0]["wordEN"].ToString().Trim() + ".htm\">" + _ppName + "</a></li>";
                    }
                    else
                    {
                        shopInfo.Text = "<div class=\"height15px\"></div>";
                    }

                    string item_url = dt.Rows[0]["item_url"].ToString().Trim();

                    titleStr = dt.Rows[0]["title"].ToString().Trim();
                    cidTemp = xabara.isNum(dt.Rows[0]["classID"].ToString().Trim());
                    classNav = c.readClassName_Link(cidTemp, "/item/*.htm", "navClass");

                    //优惠券
                    string end_time = dt.Rows[0]["coupon_end_time"].ToString().Trim();
                    if (!string.IsNullOrWhiteSpace(end_time))
                    {
                        DateTime _coupon_end_time = Convert.ToDateTime(end_time);
                        if (_coupon_end_time >= Convert.ToDateTime(DateTime.Now.ToShortDateString()))
                        {
                            couponHtm.Text = "<table class=\"normalTable\"><tr style=\"height:168px;\"><td style=\"width: 24px; background-image: url('/images/couponArrowL.png'); background-repeat: repeat-y;\"></td><td style=\"text-align: center; vertical-align: middle; background-color: #f04f45;\"><ul style=\"color: white;\"><li style=\"font-size: 26px;\">¥&nbsp;<span style=\"font-size: 80px; font-weight: bold; font-family: 'Times New Roman', Times, serif;\">" + dt.Rows[0]["couponMoney"].ToString().Trim() + "</span>&nbsp;元</li><li style=\"line-height: 26px;\">" + dt.Rows[0]["coupon_info"].ToString().Trim() + "&nbsp;&nbsp;剩余：" + dt.Rows[0]["coupon_remain_count"].ToString().Trim() + "&nbsp;张</li><li>有效期：" + Convert.ToDateTime(dt.Rows[0]["coupon_start_time"].ToString().Trim()).ToString("yyyy.MM.dd") + " - " + _coupon_end_time.ToString("yyyy.MM.dd") + "</li><li class=\"height10px\"></li></ul></td><td style=\"width: 25px; background-color: #d7000f;\"></td><td style=\"width: 100px; text-align: center; vertical-align: middle; background-color:#d7000f;\"><a target=\"_blank\" href=\"" + dt.Rows[0]["coupon_click_url"].ToString().Trim() + "\" style=\"color: white; font-size: 30px; font-weight: bold;\">立即<br /> 领取</a></td><td style=\"width: 28px; background-image: url('/images/couponArrowR.png'); background-repeat: repeat-y; background-color:#fff;\"></td></tr></table>";
                        }
                    }
                    else
                    {
                        if (!string.IsNullOrWhiteSpace(_logo))
                        {
                            couponHtm.Text = "<img src=\"" + f.picDisplay(_logo) + "\" style=\"max-height:90px; display: inline-block; vertical-align: middle;\" />&nbsp;&nbsp;";
                        }
                        else
                        {
                            coupon.Visible = false;
                        }
                    }

                    //根分类读取
                    DataTable dtClass = s.getDataTable("select Tid,TreeName from newsTree where TreeID=0 AND TreeType='taobaoke' order by ListID ASC, Tid ASC");
                    for (int t = 0; t < dtClass.Rows.Count; t++)
                    {
                        if (cidTemp == xabara.isNum(dtClass.Rows[t]["Tid"].ToString().Trim()) || classNav.IndexOf(dtClass.Rows[t]["TreeName"].ToString().Trim()) > -1)
                        {
                            classTD.Text += "<td style=\"color:#fb3434; font-size:14px;\">" + dtClass.Rows[t]["TreeName"].ToString().Trim() + "</td>";
                        }
                        else
                        {
                            classTD.Text += "<td><a href=\"/item/" + dtClass.Rows[t]["Tid"].ToString().Trim() + "-0-0.htm\" target=\"_top\" class=\"classID\">" + dtClass.Rows[t]["TreeName"].ToString().Trim() + "</a></td>";
                        }
                    }
                    dtClass.Dispose();

                    navClass.Text = "当前位置：<a href=\"/\" target=\"_top\" class=\"navClass\">首页</a>&nbsp;-&nbsp;" + classNav;
                    pic.Text = "<a target=\"_blank\" biz-itemid=\"" + id.ToString() + "\" isconvert=1 href=\"" + item_url + "\"><div id=\"bigPic\"><img class=\"divHuiLine\" src=\"" + dt.Rows[0]["pic_url"].ToString().Trim() + "\" style=\"width:400px;\" id=\"showImg\" /></div></a>";
                    string smallPic = dt.Rows[0]["small_images"].ToString().Trim();
                    if (!string.IsNullOrWhiteSpace(smallPic))
                    {
                        string[] img = smallPic.Split(new char[] { '|' });
                        for (int i = 0; i <= img.GetUpperBound(0); i++)
                        {
                            smallPicHtm.Text += "<img class=\"divHuiLine\" style=\"width:100px; cursor:pointer;\" val=\"" + img[i] + "\" src=\"" + img[i] + "_b.jpg\" />&nbsp;&nbsp;";
                        }
                    }

                    tbTitle.Text = titleStr;
                    shopTitle.Text = "<span style=\"padding:0 15px 0 15px; font-weight:bold; color:#666;\">" + _nick + "</span><span><a title=\"" + titleStr + "\" target=\"_blank\" biz-itemid=\"" + id.ToString() + "\" isconvert=1 href=\"" + item_url + "\">" + CHAR.left(titleStr, 35) + "</a></span>";

                    double reserve_price = Convert.ToDouble(dt.Rows[0]["reserve_price"].ToString().Trim());
                    double final_price = Convert.ToDouble(dt.Rows[0]["zk_final_price"].ToString().Trim());
                    if (reserve_price > final_price)
                    {
                        oldPrice.Text = "<li>原价：<span class=\"moneyLineFont\" style=\"font-size:16px;\">" + rmb.format(reserve_price.ToString()) + "</span></li>";
                    }

                    tbPrice.Text = rmb.format(final_price.ToString());
                    buyNums.Text = dt.Rows[0]["volume"].ToString().Trim();
                    location.Text = dt.Rows[0]["provcity"].ToString().Trim();

                    buyView.Text = "<a class=\"head\" target=\"_blank\" biz-itemid=\"" + id.ToString() + "\" isconvert=1 href=\"" + item_url + "\">商品详情</a>";
                    buyView2.Text = buyView.Text;
                    buy.Text = "<a class=\"head\" target=\"_blank\" biz-itemid=\"" + id.ToString() + "\" isconvert=1 href=\"" + item_url + "\">立即购买</a>";
                    buy2.Text = buy.Text;
                }
                else
                {
                    Response.Redirect("/", true);
                }
                dt.Dispose();

                //优惠券绑定
                strSql = "select top 6 * from coupon where seller_id=" + _seller_id + " order by coupon_start_time DESC";                
                dt = s.getDataTable(strSql);
                if (dt.Rows.Count < 1)
                {
                    strSql = "select top 6 * from coupon where coupon_start_time<=CONVERT(varchar(100), GETDATE(), 23) and coupon_end_time>=CONVERT(varchar(100), GETDATE(), 23) and keywordID=" + _keywordID + " and classID=" + cidTemp + " order by coupon_start_time DESC";
                    dt = s.getDataTable(strSql);
                }
                //Response.Write(strSql);
                if (dt.Rows.Count == 6)
                {
                    //品牌优惠券
                    morePP.Text = "<div class=\"divWidth\" style=\"height:30px; line-height:30px; text-align:right;\"><a href=\"/coupon/?cid=" + cidTemp + "&kid=" + _keywordID + "\" target=\"_blank\" class=\"classID\">更多" + _ppName + "优惠券 ></a></div>";
                }

                couponList.DataSource = dt.DefaultView;
                couponList.DataBind();
                couponList.Dispose();
                dt.Dispose();
            }
            else
            {
                Response.Redirect("/", true);
            }

            //关联商品获取
            string[] strValue = new string[30];
            string appsecret = xml.read("xabara.config", "appSecret", 60);
            string url = xml.read("xabara.config", "taobaoKeUrl", 60);
            ITopClient client = new DefaultTopClient(url, appkey, appsecret);
            TbkItemRecommendGetRequest req = new TbkItemRecommendGetRequest();
            req.Fields = "num_iid,title,pict_url,small_images,reserve_price,zk_final_price,user_type,provcity,item_url";
            req.NumIid = id;
            req.Count = 25L;
            req.Platform = 1L;
            TbkItemRecommendGetResponse response = client.Execute(req);
            long shopNums = response.Results.Count;
            if (shopNums > 20) //只显示3行
            {
                shopNums = 20;
            }
            if (shopNums > 0)
            {
                for (int i = 0; i < shopNums; i++)
                {
                    if ((i + 1) % 5 == 1)
                    {
                        itemsHtm.Text += "<tr>";
                    }

                    itemsHtm.Text += "<td style=\"padding-bottom: 8px;\" onmouseover=\"this.className='divRedLine'\" onmouseout=\"this.className='divOutLine'\" valign=\"top\" class=\"divOutLine\"><table class=\"itemTable\" style=\"width: 100%;\"><tr><td colspan=\"2\" style=\"padding: 0;\"><div style=\"text-align: center; height: 226px; overflow: hidden;\"><a biz-itemid=\"" + response.Results[i].NumIid + "\" isconvert=1 href=\"" + response.Results[i].ItemUrl + "\" target=\"_blank\"><img style=\"width: 226px;\" src=\"" + response.Results[i].PictUrl + "_250x250.jpg\" alt=\"" + response.Results[i].Title + "\" title=\"" + response.Results[i].Title + "\" /></a></div></td></tr><tr><td><span class=\"moneyLineFont\">" + rmb.format(response.Results[i].ReservePrice) + "</span></td><td style=\"text-align: right;\"><span class=\"moneyFont\">" + rmb.format(response.Results[i].ZkFinalPrice) + "</span></td></tr><tr><td colspan=\"2\"><a biz-itemid=\"" + response.Results[i].NumIid + "\" isconvert=1 href=\"" + response.Results[i].ItemUrl + "\" target=\"_blank\"><div class=\"title12_H36\">" + response.Results[i].Title + "</div></a></td></tr></table></td>";

                    if ((i + 1) % 5 != 0)
                    {
                        itemsHtm.Text += "<td style=\"width: 15px;\"></td>";
                    }

                    if ((i + 1) % 5 == 0 && i < shopNums - 1)
                    {
                        itemsHtm.Text += "<tr><tr><td colspan=\"5\" class=\"height15px\"></td></tr>";
                    }
                }
            }
            else
            {
                dt = s.getDataTable("select top 25 num_iid,item_url,pic_url,item_url,title,reserve_price,zk_final_price from taobaoke where keywordID=" + _keywordID + " order by volume desc");
                shopNums = dt.Rows.Count;
                if (shopNums > 0)
                {
                    for (int i = 0; i < shopNums; i++)
                    {
                        if ((i + 1) % 5 == 1)
                        {
                            itemsHtm.Text += "<tr>";
                        }

                        itemsHtm.Text += "<td style=\"padding-bottom: 8px;\" onmouseover=\"this.className='divRedLine'\" onmouseout=\"this.className='divOutLine'\" valign=\"top\" class=\"divOutLine\"><table class=\"itemTable\" style=\"width: 100%;\"><tr><td colspan=\"2\" style=\"padding: 0;\"><div style=\"text-align: center; height: 226px; overflow: hidden;\"><a biz-itemid=\"" + dt.Rows[i]["num_iid"].ToString().Trim() + "\" isconvert=1 href=\"" + dt.Rows[i]["item_url"].ToString().Trim() + "\" target=\"_blank\"><img style=\"width: 226px;\" src=\"" + dt.Rows[i]["pic_url"].ToString().Trim() + "_250x250.jpg\" alt=\"" + dt.Rows[i]["title"].ToString().Trim() + "\" title=\"" + dt.Rows[i]["title"].ToString().Trim() + "\" /></a></div></td></tr><tr><td><span class=\"moneyLineFont\">" + rmb.format(dt.Rows[i]["reserve_price"].ToString().Trim()) + "</span></td><td style=\"text-align: right;\"><span class=\"moneyFont\">" + rmb.format(dt.Rows[i]["zk_final_price"].ToString().Trim()) + "</span></td></tr><tr><td colspan=\"2\"><a biz-itemid=\"" + dt.Rows[i]["num_iid"].ToString().Trim() + "\" isconvert=1 href=\"" + dt.Rows[i]["item_url"].ToString().Trim() + "\" target=\"_blank\"><div class=\"title12_H36\">" + dt.Rows[i]["title"].ToString().Trim() + "</div></a></td></tr></table></td>";

                        if ((i + 1) % 5 != 0)
                        {
                            itemsHtm.Text += "<td style=\"width: 15px;\"></td>";
                        }

                        if ((i + 1) % 5 == 0 && i < shopNums - 1)
                        {
                            itemsHtm.Text += "<tr><tr><td colspan=\"5\" class=\"height15px\"></td></tr>";
                        }
                    }
                }
                dt.Dispose();
            }

            x.webMeta(this.Page, titleStr + " " + _nick + " " + xml.read("xabara.config", "KeyWord", 60), xml.read("xabara.config", "metaStr", 60));
        }

        this.Page.Title = titleStr + " " + _nick + xml.read("xabara.config", "titleMeta", 60);
    }

    public string money(string str)
    {
        return rmb.format(str);
    }
    public string cut(string str, int len)
    {
        return CHAR.left(str, len);
    }
}