﻿using System;
using System.Web.UI;
using System.Data;
using xabaraCOM;
public partial class m_item_show : System.Web.UI.Page
{
    public string mmPid = string.Empty;
    public string appkey = string.Empty;
    protected void Page_Load(object sender, EventArgs e)
    {
        string titleStr = "乡巴佬CMS_xabara.com";
        string _nick = string.Empty;

        if (!IsPostBack)
        {
            appkey = xml.read("xabara.config", "appkey", 60);
            mmPid = xml.read("xabara.config", "itemPID", 60);

            xabara x = new xabara();
            sqlServer s = new sqlServer();
            classify c = new classify();
            fileDocument f = new fileDocument();
            DataTable dt;

            long id = xabara.isNum(Request.QueryString["id"]);
            if (id < 1)
            {
                object urlID = Page.RouteData.Values["sID"];
                if (!string.IsNullOrWhiteSpace(urlID as string))
                {
                    string _urlID = urlID.ToString().Replace(".htm", "");
                    id = xabara.isNum(_urlID);
                }
            }

            //读取信息
            long cidTemp = 0;
            string _ppName = string.Empty;
            string _seller_id = string.Empty;
            string _keywordID = "0";

            if (id > 0)
            {
                string strSql = "select coupon.couponMoney,coupon.coupon_remain_count,coupon.coupon_info,coupon.coupon_start_time,coupon.coupon_end_time,coupon.coupon_click_url,t.* from (select newstree.TreeName,newstree.treeNameTxt,keywordID.wordEN,keywordID.wordName,keywordID.logo,keywordID.bigPic,taobaoke.keywordID,taobaoke.title,taobaoke.classID,taobaoke.item_url,taobaoke.seller_id,taobaoke.pic_url,taobaoke.small_images,taobaoke.reserve_price,taobaoke.zk_final_price,taobaoke.volume,taobaoke.nick,taobaoke.provcity from taobaoke left join newstree on taobaoke.classID=newstree.Tid left join keywordID on taobaoke.keywordID=keywordID.id where taobaoke.num_iid=" + id.ToString() + ") as t left join coupon on coupon.seller_id=t.seller_id and coupon.couponMaxMoney<=t.zk_final_price order by couponMoney desc";
                dt = s.getDataTable(strSql);

                if (dt.Rows.Count > 0)
                {
                    string _logo = dt.Rows[0]["logo"].ToString().Trim();
                    if(!string.IsNullOrWhiteSpace(_logo))
                    {
                        shop.Text = "<img style=\"height:4rem; vertical-align:middle;\" src=\"" + f.filePath(_logo) + "\" />&nbsp;";
                    }
                    _ppName = dt.Rows[0]["wordName"].ToString().Trim();
                    _nick = dt.Rows[0]["nick"].ToString().Trim();
                    if (string.IsNullOrWhiteSpace(_nick))
                    {
                        _nick = _ppName + "混合专卖店";
                    }
                    _seller_id = dt.Rows[0]["seller_id"].ToString().Trim();
                    _keywordID = dt.Rows[0]["keywordID"].ToString().Trim();

                    if (xabara.isNum(_seller_id) > 0)
                    {
                        shop.Text += "<a target=\"_blank\" biz-sellerid=\"" + _seller_id + "\" isconvert=1 href=\"https://store.taobao.com/shop/view_shop.htm?user_number_id=" + _seller_id + "\" style=\"color:#051b28; font-size:2rem;\">" + _nick + "</a>";
                    }

                    string item_url = dt.Rows[0]["item_url"].ToString().Trim();

                    titleStr = dt.Rows[0]["title"].ToString().Trim();
                    cidTemp = xabara.isNum(dt.Rows[0]["classID"].ToString().Trim());

                    //优惠券
                    string end_time = dt.Rows[0]["coupon_end_time"].ToString().Trim();
                    if (!string.IsNullOrWhiteSpace(end_time))
                    {
                        DateTime _coupon_end_time = Convert.ToDateTime(end_time);
                        if (_coupon_end_time >= Convert.ToDateTime(DateTime.Now.ToShortDateString()))
                        {
                            couponHtm.Text= "<div class=\"divWidth\" style=\"background-color:#feece8; color:#f20035;\"><div style=\"padding: 1.5rem 1rem 4rem 1rem;\"><div class=\"divLeft\">优惠券&nbsp;&yen;&nbsp;<span style=\"font-size: 2.5rem; font-weight: bold;\">" + dt.Rows[0]["couponMoney"].ToString().Trim() + "</span>&nbsp;元&nbsp;&nbsp;" + dt.Rows[0]["coupon_info"].ToString().Trim() + "</div><div class=\"divRight\"><a target=\"_blank\" href=\"" + dt.Rows[0]["coupon_click_url"].ToString().Trim() + "\" style=\"color: #f20035;\">立即领取</a></div></div></div>";
                        }
                    }

                    pic.Text = "<div class=\"swiper-slide\"><img src=\"" + dt.Rows[0]["pic_url"].ToString().Trim() + "\" style=\"width:100%; cursor:pointer;\" /></div>";
                    string smallPic = dt.Rows[0]["small_images"].ToString().Trim();
                    if (!string.IsNullOrWhiteSpace(smallPic))
                    {
                        string[] img = smallPic.Split(new char[] { '|' });
                        for (int i = 0; i <= img.GetUpperBound(0); i++)
                        {
                            pic.Text += "<div class=\"swiper-slide\"><img style=\"width:100%; cursor:pointer;\" src=\"" + img[i] + "\" /></div>";
                        }
                    }

                    tbTitle.Text = "<a target=\"_blank\" biz-itemid=\"" + id.ToString() + "\" isconvert=1 href=\"" + item_url + "\">" + titleStr + "</a>";

                    double reserve_price = Convert.ToDouble(dt.Rows[0]["reserve_price"].ToString().Trim());
                    double final_price = Convert.ToDouble(dt.Rows[0]["zk_final_price"].ToString().Trim());
                    if (reserve_price > final_price)
                    {
                        oldPrice.Text = "原价：<span class=\"moneyLineFont\">" + rmb.formatM(reserve_price.ToString()) + "</span>&nbsp;&nbsp;现价：";
                    }

                    tbPrice.Text = rmb.formatM(final_price.ToString());
                    buyNums.Text = dt.Rows[0]["volume"].ToString().Trim();
                    location.Text = dt.Rows[0]["provcity"].ToString().Trim();

                    buyView.Text = "<a target=\"_blank\" biz-itemid=\"" + id.ToString() + "\" isconvert=1 href=\"" + item_url + "\" style=\"color:white; font-size:2rem;\">商品详情</a>";
                    buy.Text = "<a target=\"_blank\" biz-itemid=\"" + id.ToString() + "\" isconvert=1 href=\"" + item_url + "\" style=\"color:white; font-size:2rem;\">立即购买</a>";
                }
                else
                {
                    Response.Redirect("/", true);
                }
                dt.Dispose();
            }
            else
            {
                Response.Redirect("/", true);
            }

            //关联商品获取
            string[] strValue = new string[30];
            dt = s.getDataTable("select top 6 num_iid,item_url,pic_url,item_url,title,reserve_price,zk_final_price from taobaoke where keywordID=" + _keywordID + " order by volume desc");
            int shopNums = dt.Rows.Count;
            if (shopNums > 0)
            {
                for (int i = 0; i < shopNums; i++)
                {
                    if ((i + 1) % 2 == 1)
                    {
                        itemsHtm.Text += "<tr>";
                    }

                    itemsHtm.Text += "<td style=\"padding-bottom: 8px; width:49%;\" valign=\"top\"><table class=\"itemTable\" style=\"width: 100%;\"><tr><td colspan=\"2\" style=\"padding: 0;\"><div style=\"text-align: center; overflow: hidden;\"><a biz-itemid=\"" + dt.Rows[i]["num_iid"].ToString().Trim() + "\" isconvert=1 href=\"" + dt.Rows[i]["item_url"].ToString().Trim() + "\" target=\"_blank\"><img style=\"width: 100%;\" src=\"" + dt.Rows[i]["pic_url"].ToString().Trim() + "\" /></a></div></td></tr><tr><td><span class=\"moneyLineFont\">" + rmb.formatM(dt.Rows[i]["reserve_price"].ToString().Trim()) + "</span></td><td style=\"text-align: right;\"><span class=\"moneyFont\">" + rmb.formatM(dt.Rows[i]["zk_final_price"].ToString().Trim()) + "</span></td></tr><tr><td colspan=\"2\"><div style=\"overflow: hidden; height:7rem;\"><a biz-itemid=\"" + dt.Rows[i]["num_iid"].ToString().Trim() + "\" isconvert=1 href=\"" + dt.Rows[i]["item_url"].ToString().Trim() + "\" target=\"_blank\">" + dt.Rows[i]["title"].ToString().Trim() + "</a></div></td></tr></table></td>";

                    if ((i + 1) % 2 != 0)
                    {
                        itemsHtm.Text += "<td style=\"width:2%;\"></td>";
                    }
                }
            }
            dt.Dispose();

            x.webMeta(this.Page, titleStr + " " + _nick + " " + xml.read("xabara.config", "KeyWord", 60), xml.read("xabara.config", "metaStr", 60));

            countStr.Text = xml.read("xabara.config", "countScript", 60);
        }

        this.Page.Title = titleStr + " " + _nick + xml.read("xabara.config", "titleMeta", 60) + " 手机版";
    }
}