﻿using System;
using xabaraCOM;
using Top.Api;
using Top.Api.Request;
using Top.Api.Response;
public partial class search_Default : System.Web.UI.Page
{
    public string mmPid = string.Empty;
    public string appkey = string.Empty;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            appkey = xml.read("xabara.config", "appkey", 60);
            mmPid = xml.read("xabara.config", "itemPID", 60);

            xabara x = new xabara();
            sqlServer s = new sqlServer();

            string _word = s.sqlVerifyString(Request.QueryString["word"]);
            string _type = s.sqlVerifyString(Request.QueryString["type"]);

            if (!string.IsNullOrWhiteSpace(_word) && !string.IsNullOrWhiteSpace(_type as string))
            {
                switch (_type)
                {
                    case "item":
                        Response.Redirect("/item/search.htm?word=" + Server.UrlEncode(_word));
                        break;
                    case "coupon":
                        Response.Redirect("/coupon/?word=" + Server.UrlEncode(_word));
                        break;
                    default:
                        Response.Redirect("/item/search.htm?word=" + Server.UrlEncode(_word));
                        break;
                }
            }
            else
            {
                if (!string.IsNullOrWhiteSpace(_word))
                {
                    //关联商品获取
                    string[] strValue = new string[30];
                    string appsecret = xml.read("xabara.config", "appSecret", 60);
                    string url = xml.read("xabara.config", "taobaoKeUrl", 60);
                    ITopClient topClient = new DefaultTopClient(url, appkey, appsecret);
                    TbkItemGetRequest req = new TbkItemGetRequest();
                    req.Fields = "num_iid,title,pict_url,small_images,reserve_price,zk_final_price,user_type,provcity,item_url,seller_id,volume,nick";
                    req.Q = _word;
                    req.Sort = "total_sales";
                    req.IsTmall = false;
                    req.PageNo = 1L;
                    req.PageSize = 100L;
                    TbkItemGetResponse response = topClient.Execute(req);
                    long shopNums = response.Results.Count;
                    if (shopNums > 0)
                    {
                        for (int i = 0; i < shopNums; i++)
                        {
                            if ((i + 1) % 5 == 1)
                            {
                                itemsHtm.Text += "<tr>";
                            }

                            itemsHtm.Text += "<td style=\"padding-bottom: 8px;\" onmouseover=\"this.className='divRedLine'\" onmouseout=\"this.className='divOutLine'\" valign=\"top\" class=\"divOutLine\"><table class=\"itemTable\" style=\"width: 100%;\"><tr><td colspan=\"2\" style=\"padding: 0;\"><div style=\"text-align: center; height: 226px; overflow: hidden;\"><a biz-itemid=\"" + response.Results[i].NumIid + "\" isconvert=1 href=\"" + response.Results[i].ItemUrl + "\" target=\"_blank\"><img style=\"width: 226px;\" src=\"" + response.Results[i].PictUrl + "_250x250.jpg\" alt=\"" + response.Results[i].Title + "\" title=\"" + response.Results[i].Title + "\" /></a></div></td></tr><tr><td><span class=\"moneyLineFont\">" + rmb.format(response.Results[i].ReservePrice) + "</span></td><td style=\"text-align: right;\"><span class=\"moneyFont\">" + rmb.format(response.Results[i].ZkFinalPrice) + "</span></td></tr><tr><td colspan=\"2\"><a biz-itemid=\"" + response.Results[i].NumIid + "\" isconvert=1 href=\"" + response.Results[i].ItemUrl + "\" target=\"_blank\"><div class=\"title12_H36\">" + response.Results[i].Title + "</div></a></td></tr><tr><td><img src=\"/images/"+ response.Results[i].UserType.ToString()+ ".jpg\" style=\"vertical-align: middle;\" />&nbsp;月销量：" + response.Results[i].Volume.ToString() + "</td><td style=\"text-align: right;\">" + response.Results[i].Provcity + "</td></tr></table></td>";

                            if ((i + 1) % 5 != 0)
                            {
                                itemsHtm.Text += "<td style=\"width: 15px;\"></td>";
                            }

                            if ((i + 1) % 5 == 0 && i < shopNums - 1)
                            {
                                itemsHtm.Text += "<tr><tr><td colspan=\"5\" class=\"height15px\"></td></tr>";
                            }
                        }
                    }
                }
                else
                {
                    Response.Redirect("/", true);
                }
            }

            x.webMeta(this.Page, xml.read("xabara.config", "KeyWord", 60), xml.read("xabara.config", "metaStr", 60));
        }

        this.Page.Title = "搜索中心 " + xml.read("xabara.config", "webName", 60) + xml.read("xabara.config", "titleMeta", 60);
    }
}