﻿using System;
using System.Data;
using xabaraCOM;

public partial class shop_Default : System.Web.UI.Page
{
    sqlServer s = new sqlServer();
    protected void Page_Load(object sender, EventArgs e)
    {
        string className = string.Empty;

        if (!IsPostBack)
        {
            xabara x = new xabara();
            classify c = new classify();
            DataTable dt;

            long cidTemp = xabara.isNum(Request.QueryString["id"]);    //分类

            if (cidTemp < 1)
            {
                object urlID = Page.RouteData.Values["cID"];
                if (!string.IsNullOrWhiteSpace(urlID as string))
                {
                    string _urlID = urlID.ToString().Replace(".htm", "");
                    cidTemp = xabara.isNum(_urlID);
                }
            }

            //根分类读取
            dt = s.getDataTable("select Tid,TreeName from newsTree where TreeID=0 AND TreeType='taobaoke' order by ListID ASC, Tid ASC");
            for (int t = 0; t < dt.Rows.Count; t++)
            {
                string treeName = dt.Rows[t]["TreeName"].ToString().Trim();

                if (cidTemp == xabara.isNum(dt.Rows[t]["Tid"].ToString().Trim()))
                {
                    classTD.Text += "<td style=\"color:#fb3434; font-size:14px;\">" + treeName + "</td>";
                }
                else
                {
                    classTD.Text += "<td><a href=\"" + dt.Rows[t]["Tid"].ToString().Trim() + ".htm\" target=\"_top\" class=\"classID\">" + treeName + "</a></td>";
                }
            }
            dt.Dispose();

            string ifStr = string.Empty;
            string strSql = "select id,wordEN,wordName,logo,listPic,isSHOP from keywordID where isBad=0 and ISNULL(listPic, N'') <> '' order by startDate desc";
            if (cidTemp > 0)
            {
                className = c.readClassName_Link(cidTemp, "", "") + "_";

                string cidStr = c.ReadAllClassID("taobaoke", cidTemp); //得到所有ID
                string[] ids = cidStr.Split(new char[] { ',' });
                for (int i = 0; i <= ids.GetUpperBound(0); i++)
                {
                    ifStr += " select id,wordEN,wordName,logo,listPic,isSHOP,startDate from keywordID where isBad=0 and ISNULL(listPic, N'') <> '' and treeID=" + ids[i] + " union";
                }

                ifStr = "(" + ifStr.Substring(0, ifStr.Length - 6) + ") as news ";

                strSql = "select * from " + ifStr + " order by startDate desc";
            }            
            //Response.Write(strSql);
            //Response.End();
            lblCurrentPage.Text = s.RepeaterDB(popList, strSql, "", 20, "page", "center", true);

            x.webMeta(this.Page, xml.read("xabara.config", "KeyWord", 60), xml.read("xabara.config", "metaStr", 60));
        }

        this.Page.Title = className + "品牌特卖 " + xml.read("xabara.config", "webName", 60) + xml.read("xabara.config", "titleMeta", 60);
    }

    public string shopItems(string id, string wordEN, string isSHOP)
    {
        //读取促销
        if (xabara.isNum(isSHOP) == 0)  //非品牌主店
        {
            wordEN = id;
        }

        string str = "<table class=\"indexSHOP\"><tr>";
        string strSql = "select top 3 num_iid,pic_url,title,reserve_price,zk_final_price,user_type,volume,provcity from taobaoke where isBad=0 and keywordID=" + id + " order by num_iid desc,volume desc";
        DataTable dt = s.getDataTable(strSql);        
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            str += "<td><ul style=\"width:228px;\"><li><a href=\"/" + wordEN + ".htm\" target=\"_blank\"><div style=\"height:228px; overflow:hidden;\"><img class=\"divLineDotted\" title=\"" + dt.Rows[i]["title"].ToString().Trim() + "\" style=\"width: 228px;\" alt=\"" + dt.Rows[i]["title"].ToString().Trim() + "\" src=\"" + dt.Rows[i]["pic_url"].ToString().Trim() + "_250x250.jpg\" /></a></li><li style=\"padding-top:3px;\"><ul class=\"ulTD\"><li><span class=\"moneyFont\">" + rmb.format(dt.Rows[i]["zk_final_price"].ToString().Trim()) + "</span></li><li style=\"text-align:right;\">月售：" + dt.Rows[i]["volume"].ToString().Trim() + "&nbsp;</li></ul></li></ul></td>";

            if (i < 2)
            {
                str += "<td style=\"width:10px;\"></td>";
            }
        }
        dt.Dispose();

        str += "</tr></table>";

        return str;
    }
    public string filePath(string str)
    {
        fileDocument f = new fileDocument();

        return f.filePath(str);
    }
}