﻿<%@ OutputCache Duration="3600" VaryByParam="page" %>

<%@ Page Language="C#" AutoEventWireup="true" CodeFile="list.aspx.cs" Inherits="top_list" %>

<%@ Register Src="~/inClude/head.ascx" TagPrefix="uc1" TagName="head" %>
<%@ Register Src="~/inClude/bottom.ascx" TagPrefix="uc1" TagName="bottom" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title></title>
    <link rel="Shortcut Icon" href="/Images/favicon.ico" />
    <link href="../inClude/style.css" rel="stylesheet" type="text/css" />
    <script src="../js/jquery.min.js" type="text/javascript"></script>
    <script src="../js/all.js" type="text/javascript"></script>
</head>
<body>
    <form id="form1" runat="server">
        <uc1:head runat="server" ID="head" />
        <div style="background-color:white;">
            <div class="divWidth" style="height:50px; line-height:50px; text-align:right;">
                <table class="navClassTable" align="right">
                    <tr>
                        <asp:Literal ID="classTD" runat="server" ViewStateMode="Disabled"></asp:Literal>
                    </tr>
                </table>
            </div>
        </div>
        <div class="height15px"></div>
        <div class="divWidth" style="background-color:white;">
            <div style="padding: 15px;">
                <asp:Repeater ID="RepeaterList" runat="server" ViewStateMode="Disabled">
                    <HeaderTemplate>
                        <table class="itemTableBig">
                    </HeaderTemplate>
                    <ItemTemplate>
                        <asp:PlaceHolder ID="PlaceHolder1" runat="server" Visible='<%# (Container.ItemIndex + 1) % 5 ==1 %>'>
                            <tr>
                        </asp:PlaceHolder>
                        <td style="padding-bottom: 8px;" onmouseover="this.className='divRedLine'" onmouseout="this.className='divOutLine'" valign="top" class="divOutLine">
                            <table class="itemTable">
                                <tr>
                                    <td colspan="2" style="padding: 0;">
                                        <div style="text-align: center; height: 220px; overflow: hidden;">
                                            <a href="/show/<%# Eval("num_iid").ToString().Trim() %>.htm" target="_blank">
                                                <img style="width: 220px;" src="<%# Eval("pic_url").ToString().Trim() %>_250x250.jpg" alt="<%# Eval("title").ToString().Trim() %>" title="<%# Eval("title").ToString().Trim() %>" /></a>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td><span class="moneyLineFont"><%# money(Eval("reserve_price").ToString().Trim())%></span></td>
                                    <td style="text-align: right;"><span class="moneyFont"><%# money(Eval("zk_final_price").ToString().Trim())%></span></td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="word12"><a href="/show/<%# Eval("num_iid").ToString().Trim() %>.htm" target="_blank"><div class="title12_H36"><%# Eval("title").ToString().Trim() %></div></a></td>
                                </tr>
                                <tr>
                                    <td colspan="2"><%# string.IsNullOrWhiteSpace(Eval("wordName").ToString().Trim())?Eval("nick").ToString().Trim():"<a href=\"/"+ Eval("keywordID").ToString().Trim() +".htm\" target=\"_blank\" class=\"line\">"+Eval("wordName").ToString().Trim()+"专卖店</a>" %></td>
                                </tr>
                                <tr>
                                    <td>
                                        <img src="../images/<%# Eval("user_type").ToString().Trim() %>.jpg" style="vertical-align: middle;" />&nbsp;月售：<%# Eval("volume").ToString().Trim() %></td>
                                    <td style="text-align: right;"><%# Eval("provcity").ToString().Trim() %>&nbsp;</td>
                                </tr>
                            </table>
                        </td>
                        <asp:PlaceHolder ID="PlaceHolder3" runat="server" Visible='<%# (Container.ItemIndex + 1) % 5 >0 %>'>
                            <td style="width: 15px;"></td>
                        </asp:PlaceHolder>
                        <asp:PlaceHolder ID="PlaceHolder2" runat="server" Visible='<%# (Container.ItemIndex + 1) % 5==0 %>'></tr>
                        <tr>
                            <td colspan="5" class="height15px"></td>
                        </tr>
                        </asp:PlaceHolder>
                    </ItemTemplate>
                    <FooterTemplate>
                        </table>
                    </FooterTemplate>
                </asp:Repeater>
                <div>
                    <asp:Literal ID="lblCurrentPage" runat="server" ViewStateMode="Disabled"></asp:Literal>
                </div>
            </div>
        </div>
        <uc1:bottom runat="server" ID="bottom" />
    </form>
</body>
</html>