﻿using System;
using System.Data;
using xabaraCOM;

public partial class top_list : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string className = string.Empty;

        if (!IsPostBack)
        {
            long cidTemp = xabara.isNum(Request.QueryString["id"]);    //分类

            if (cidTemp < 1)
            {
                object urlID = Page.RouteData.Values["cID"];
                if (!string.IsNullOrWhiteSpace(urlID as string))
                {
                    string _urlID = urlID.ToString().Replace(".htm", "");
                    cidTemp = xabara.isNum(_urlID);
                }
            }

            xabara x = new xabara();
            sqlServer s = new sqlServer();
            classify c = new classify();
            DataTable dt;

            //根分类读取
            dt = s.getDataTable("select Tid,TreeName from newsTree where TreeID=0 AND TreeType='taobaoke' order by ListID ASC, Tid ASC");
            for (int t = 0; t < dt.Rows.Count; t++)
            {
                string treeName = dt.Rows[t]["TreeName"].ToString().Trim();

                if (cidTemp == xabara.isNum(dt.Rows[t]["Tid"].ToString().Trim()))
                {
                    classTD.Text += "<td style=\"color:#fb3434; font-size:14px;\">" + treeName + "</td>";
                }
                else
                {
                    classTD.Text += "<td><a href=\"" + dt.Rows[t]["Tid"].ToString().Trim() + ".htm\" target=\"_top\" class=\"classID\">" + treeName + "</a></td>";
                }
            }
            dt.Dispose();

            string ifStr = string.Empty;
            string strSql = "select top 1000 keywordID.wordName,keywordID.wordEN,t.* from (SELECT keywordID,classID,num_iid,title,pic_url,reserve_price,zk_final_price,item_url,volume,user_type,provcity,nick,ROW_NUMBER() OVER (PARTITION BY keywordID ORDER BY volume DESC) rid from taobaoke where isGood=1) as t left join keywordID on t.keywordID=keywordID.id where rid=1 order by volume desc";
            if (cidTemp > 0)
            {
                className = c.readClassName_Link(cidTemp, "", "") + "_";

                string cidStr = c.ReadAllClassID("taobaoke", cidTemp); //得到所有ID
                string[] ids = cidStr.Split(new char[] { ',' });
                for (int i = 0; i <= ids.GetUpperBound(0); i++)
                {
                    ifStr += " select keywordID,classID,num_iid,title,pic_url,reserve_price,zk_final_price,item_url,volume,user_type,provcity from taobaoke where isGood=1 and classID=" + ids[i] + " union ";
                }

                ifStr = "(" + ifStr.Substring(0, ifStr.Length - 6) + ") as news ";

                strSql = "select keywordID.wordName,keywordID.wordEN,t.* from (SELECT keywordID,classID,num_iid,title,pic_url,reserve_price,zk_final_price,item_url,volume,user_type,provcity,ROW_NUMBER() OVER (PARTITION BY keywordID ORDER BY volume DESC) rid from " + ifStr + ") as t left join keywordID on t.keywordID=keywordID.id where rid<3 order by volume desc";
            }
            else
            {
                Response.Redirect("/top/", true);
            }
            //Response.Write(strSql);
            lblCurrentPage.Text = s.RepeaterDB(RepeaterList, strSql, "", 50, "page", "center", true);
            int count = this.RepeaterList.Items.Count;
            if (count % 5 != 0)
            {
                lblCurrentPage.Text = "<div class=\"height20px\"></div>" + lblCurrentPage.Text;
            }

            x.webMeta(this.Page, xml.read("xabara.config", "KeyWord", 60), xml.read("xabara.config", "metaStr", 60));
        }

        this.Page.Title = className + "大牌推荐_销售之王 " + xml.read("xabara.config", "webName", 60) + xml.read("xabara.config", "titleMeta", 60);
    }
    public string money(string str)
    {
        return rmb.format(str);
    }

    public string cut(string str, int len)
    {
        return CHAR.left(str, len);
    }
}