﻿using System;
using System.Web;
using System.Web.UI;
using xabaraCOM;
using System.Data;

public partial class WebXabara_Default : System.Web.UI.Page
{
    javasrcipt js = new javasrcipt();
    admin a = new admin();
    pcServer pc = new pcServer();
    ipAddress ip = new ipAddress();
    xabara x = new xabara();
    sqlServer sql = new sqlServer();

    protected void Page_Load(object sender, EventArgs e)
    {
        Page.Title = xml.read("xabara.config", "webName", 360) + " 管理系统";

        string errorStr = Request.QueryString["errorTitle"];
        if (!string.IsNullOrWhiteSpace(errorStr as string))
        {
            js.div("登录提示", 5, "重新登录", Server.UrlDecode(HttpUtility.HtmlEncode(errorStr)), 0, "?url=" + Server.UrlEncode(Request.QueryString["url"]), "top");
        }
        else
        {
            if (!string.IsNullOrWhiteSpace(Session["AdminRndNums"] as string)) //基本session验证免登录
            {
                Response.Redirect("admin.aspx", true);
            }
        }

        if (!IsPostBack)
        {
            ClientName.Text = Request.Url.Host;
            WebVer.Text = xml.read("xabara.config", "webName", 360) + "管理系统&nbsp;" + a.ver;

            if (Request.Cookies["XabaraAdmin"] != null)
            {
                UID.Text = Request.Cookies["XabaraAdmin"]["AdminID"].Trim();
            }

            clintIE.Text = pc.ie;
            clintIEver.Text = pc.iever;

            if (pc.ie.ToLower().Equals("ie")) //判断浏览器
            {
                if (Convert.ToDouble(pc.iever) < 8)  //判断浏览器版本
                {
                    ieError.Text = @"版本提示：为了更好的体验本管理系统，我们建议您升级 <a href='https://windows.microsoft.com/zh-cn/internet-explorer/download-ie/' target='_blank' style='color:red;font-weight:bold;'>Internet Explorer</a> 新版浏览器！";
                }
            }
            else
            {
                ieError.Text = "友情提示：为了更好的体验本管理系统，我们建议您使用windows 10操作系统";
            }

            string clientIP = ip.address();
            ipStr.Text = "<span style=\"color:red;\">" + clientIP + "</span>&nbsp;" + ip.addressCN(clientIP);
            //ip限制
            string ips = xml.read("xabara.config", "ip", 360);
            if (!string.IsNullOrWhiteSpace(ips as string))
            {
                if (ips.IndexOf(clientIP) < 0)
                {
                    ipStr.Text += " <span class=\"redF\">您的IP不允许登录！</span>";
                    myLogin.Enabled = false;
                    UID.Enabled = false;
                    PW.Enabled = false;
                    RndNum.Enabled = false;
                }
            }

            regExpression reg = new regExpression();
            UIDRegularExpressionValidator.ValidationExpression = reg.userID(2, 20);
            UIDRegularExpressionValidator.ErrorMessage = "用户名提示：" + reg.userIDError(2, 20);
            PWRegularExpressionValidator.ValidationExpression = reg.passWord(6, 20);
            PWRegularExpressionValidator.ErrorMessage = "密码提示：" + reg.passWordError(6, 20);
            RndNumReg.ValidationExpression = reg.rndNums(6, 20);
            RndNumReg.ErrorMessage = reg.rndNumsError(6, 20);
        }
    }

    protected void myLogin_Click(object sender, EventArgs e)
    {
        if (x.checkValidateCode(true, RndNum.Text))
        {
            string uid = UID.Text.Trim().ToLower();
            string pw = xabara.md5(PW.Text);
            string strSql = "select * from AdminUser where userID='" + uid + "' and UserPW='" + pw + "'";
            //Response.Write(strSql);
            //Response.End();
            DataTable dt = sql.getDataTable(strSql);

            if (dt.Rows.Count < 1)
            {
                js.div("登录提示", 5, "重新登录", "您的帐号或密码不正确！", 0, a.adminFolder, "top");
            }
            else
            {
                long flag = xabara.isNum(dt.Rows[0]["loginFlag"].ToString().Trim());
                if (flag < 2)
                {
                    if (flag == 1)
                    {
                        js.div("登录提示", 5, "重新登录", "您的帐号权限还没开通，请联系管理员！", 0, a.adminFolder, "top");
                    }
                    else
                    {
                        js.div("登录提示", 5, "重新登录", "您的帐号已被禁用，请联系管理员！", 0, a.adminFolder, "top");
                    }
                }
                else
                {
                    long lgNums = xabara.isNum(dt.Rows[0]["LoginNum"].ToString()) + 1;
                    string strDim = "@SessionError,@LoginNum,@LoginDate,@LoginIP";
                    string rndNums = xabara.rnd("abc", 8);
                    Session.Add("AdminRndNums", rndNums);

                    string[] strValue = new string[5];
                    strValue[0] = xabara.md5(rndNums);
                    strValue[1] = lgNums.ToString();
                    strValue[2] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                    strValue[3] = ip.address();
                    sql.update("AdminUser", strDim, strValue, "userID='" + uid + "'");

                    sql.log(uid, "admin", "管理员登录");

                    HttpCookie XabaraAdminCookies = new HttpCookie("XabaraAdmin");  //cookies写入磁盘
                    XabaraAdminCookies.Values.Add("AdminID", uid);
                    XabaraAdminCookies.Values.Add("AdminName", HttpUtility.UrlEncode(dt.Rows[0]["UserName"].ToString().Trim()));
                    XabaraAdminCookies.Values.Add("AdminLgDate", dt.Rows[0]["LoginDate"].ToString().Trim());
                    XabaraAdminCookies.Values.Add("AdminLgIP", dt.Rows[0]["LoginIP"].ToString().Trim());
                    XabaraAdminCookies.Expires = DateTime.Now.AddDays(15d);
                    Response.Cookies.Add(XabaraAdminCookies);

                    Response.Redirect("admin.aspx", true);
                }
            }

            dt.Dispose();
        }
    }
}
