﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="edit.aspx.cs" Inherits="WebXabara_ads_edit" EnableEventValidation="false" ValidateRequest="false" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>管理广告</title>
    <script src="/js/jquery.min.js" type="text/javascript"></script>
    <script src="/js/all.js" type="text/javascript"></script>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div class="divWidth">
            <div class="titleBg">
                管理广告<asp:ScriptManager ID="ScriptManager1" runat="server" AsyncPostBackTimeout="3600"></asp:ScriptManager>
            </div>
            <div class="height10px">
            </div>
            <div>
                <table width="100%" class="tableLine">
                    <tr>
                        <td class="tdTitle">广告位置
                        </td>
                        <td class="tdContent">
                            <asp:UpdatePanel ID="UpdatePanel1" runat="server" ChildrenAsTriggers="True" RenderMode="Inline" UpdateMode="Conditional">
                                <ContentTemplate>
                                    <asp:DropDownList ID="adClass" runat="server" CssClass="inputTextIME" AutoPostBack="True" OnSelectedIndexChanged="adClass_SelectedIndexChanged">
                                        <asp:ListItem Value="">== 请选择 ==</asp:ListItem>
                                    </asp:DropDownList>
                                    宽
                                    <asp:TextBox ID="adW" runat="server" CssClass="inputTextIME" Width="50px"></asp:TextBox>
                                    高
                                    <asp:TextBox ID="adH" runat="server" CssClass="inputTextIME" Width="50px"></asp:TextBox>
                                    &nbsp;<asp:Label ID="adSelect" runat="server" Font-Bold="True" ForeColor="#FF3300"></asp:Label>
                                </ContentTemplate>
                            </asp:UpdatePanel>
                            <asp:RequiredFieldValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RequiredFieldValidator6"
                                runat="server" ControlToValidate="adClass" ErrorMessage="请选择广告位置"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td class="tdTitle">广告类型
                        </td>
                        <td class="tdContent">
                            <asp:RadioButtonList ID="adImg" runat="server" RepeatDirection="Horizontal"
                                RepeatLayout="Flow" CellPadding="2" CellSpacing="2">
                            </asp:RadioButtonList>
                        </td>
                    </tr>
                    <tr>
                        <td class="tdTitle">选择文件
                        </td>
                        <td class="tdContent">
                            <asp:FileUpload ID="imgUpload" runat="server" CssClass="inputTextIME" Width="500px" />
                            <asp:HiddenField ID="upImg" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td class="tdTitle">连接网址
                        </td>
                        <td class="tdContent">
                            <asp:TextBox ID="adHttp" runat="server" CssClass="inputTextIME" Width="500px"></asp:TextBox>
                            <asp:RegularExpressionValidator SetFocusOnError="True" ForeColor="#ff3300" ID="httpRegExpree"
                                runat="server" ControlToValidate="adHttp"></asp:RegularExpressionValidator>
                        </td>
                    </tr>
                    <tr>
                        <td class="tdTitle">广告代码
                        </td>
                        <td class="tdContent">
                            <asp:TextBox ID="adCode" runat="server" CssClass="inputTextIME" Width="500px" Height="200px"
                                TextMode="MultiLine"></asp:TextBox>
                            <br />
                            注意：添加script广告代码时，删除回车、空格等符号！
                        </td>
                    </tr>
                    <tr>
                        <td class="tdTitle">开始时间
                        </td>
                        <td class="tdContent">
                            <asp:TextBox ID="pDate" runat="server" Width="200px" MaxLength="50" CssClass="inputTextIME" placeholder="yyyy-MM-dd"></asp:TextBox>
                            <asp:RequiredFieldValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RequiredFieldValidator4"
                                runat="server" ControlToValidate="pDate" ErrorMessage="*"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td class="tdTitle">结束时间
                        </td>
                        <td class="tdContent">
                            <asp:TextBox ID="eDate" runat="server" Width="200px" MaxLength="50" CssClass="inputTextIME" placeholder="yyyy-MM-dd"></asp:TextBox>
                            <asp:RequiredFieldValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RequiredFieldValidator1"
                                runat="server" ControlToValidate="eDate" ErrorMessage="*"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td class="tdTitle">&nbsp;
                        </td>
                        <td class="tdContent">
                            <asp:Button ID="editMoney" runat="server" Text="确认修改" CssClass="inputBottom" OnClick="editMoney_Click" />
                        </td>
                    </tr>
                </table>
            </div>
            <div class="height10px">
            </div>
            <div style="text-align: left;">
                <asp:Literal ID="adCodeImg" runat="server"></asp:Literal>
            </div>
        </div>
    </form>
    <script type="text/javascript">
        layui.use('laydate', function () {
            var laydate = layui.laydate;

            //执行一个laydate实例
            laydate.render({
                elem: '#pDate' //指定元素
                , type: 'date'
                , format: 'yyyy-MM-dd'
                , theme: '#0A7FC3'
            });

            laydate.render({
                elem: '#eDate' //指定元素
                , type: 'date'
                , format: 'yyyy-MM-dd'
                , theme: '#0A7FC3'
            });
        });
    </script>
</body>
</html>
