﻿using System;
using System.Web;
using System.Data;
using xabaraCOM;

public partial class webXabara_class_ClassAdd : System.Web.UI.Page
{
    admin a = new admin();
    sqlServer sql = new sqlServer();
    classify c = new classify();
    javasrcipt js = new javasrcipt();
    fileDocument f = new fileDocument();
    ipAddress i = new ipAddress();
    string typeClss = HttpContext.Current.Request.QueryString["tClass"].ToString().Trim();

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check("|" + typeClss + "Class|");
        if (!IsPostBack)
        {
            string adminClassStr = Request.QueryString["cid"];
            if (!string.IsNullOrWhiteSpace(adminClassStr as string))
            {
                c.bindingSingleClass(adminClass, 0, true, "professional");
                linkClass.Text = Request.QueryString["cidStr"];

                if (!string.IsNullOrWhiteSpace(Session["adminClass"] as string))
                {
                    this.adminClass.Items.FindByValue(Session["adminClass"].ToString().Trim()).Selected = true;
                }

                c.bindingDropDownList("all", false, xabara.isNum(adminClass.Text), typeClss, DropDownListClass);
            }
            else
            {
                linkClassTr.Visible = false;
                c.bindingDropDownList("all", false, 0, typeClss, DropDownListClass);
            }

            if (!string.IsNullOrWhiteSpace(Session[typeClss] as string))
            {
                this.DropDownListClass.Items.FindByValue(Session[typeClss].ToString().Trim()).Selected = true;
            }
            else
            {
                this.DropDownListClass.Items.FindByText("== 新增根分类 ==").Selected = true;
            }
            c.bindingTreeList(xabara.isNum(adminClass.Text), typeClss, treeList, string.Empty, "top", false, true, "");

            regExpression reg = new regExpression();
            classListRegExpre.ValidationExpression = reg.number;
            classListRegExpre.ErrorMessage = reg.numberError;

            titleClass.Text = Server.UrlDecode(Request.QueryString["title"]);
        }
    }

    protected void addClass_Click(object sender, EventArgs e)
    {
        string classNameTemp = className.Text.Trim();
        string oldClassID = DropDownListClass.Text.Trim();
        string adminclass = adminClass.Text;
        if (string.IsNullOrWhiteSpace(adminclass as string))
        {
            adminclass = "0";
        }
        Session.Add(typeClss, oldClassID); //缓存
        Session.Add("adminClass", adminClass.Text);
        string strSql = "select * from NewsTree where TreeID=" + oldClassID + " and TreeName='" + classNameTemp + "' and TreeType='" + typeClss + "' and treeAdmin=" + adminclass;

        if (sql.getDataTable(strSql).Rows.Count > 0)
        {
            js.div("", 0, "", "已存在该分类！", 0, "ClassAdd.aspx?tClass=" + typeClss + "&title=" + titleClass.Text + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
        }
        else
        {
            string img = string.Empty;
            if (upFile.HasFile)    //本地上传
            {
                f.del(img);

                f.upload(upFile, "Img", false);
                img = Session["NewFile"].ToString().Trim();
            }

            string dimStr = "@TreeID,@ListID,@TreeName,@TreeType,@treeAdmin,@treeDel,@PostDate,@AdminIP,@AdminID,@TreeUrl,@TreeNameImg,@Tid";

            string[] strValue = new string[15];
            strValue[0] = oldClassID;

            if (string.IsNullOrWhiteSpace(classList.Text))
                strValue[1] = "0";
            else
                strValue[1] = classList.Text;

            strValue[2] = classNameTemp;
            strValue[3] = typeClss;
            strValue[4] = adminclass;
            strValue[5] = "0";
            strValue[6] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            strValue[7] = i.address();
            strValue[8] = a.uid;
            strValue[9] = classUrl.Text;
            strValue[10] = img;
            strValue[11] = (xabara.isNum(xabara.rnd("123", 2)) + 10).ToString() + DateTime.Now.ToString("yyyyMMddHHmmss") + xabara.rnd("123", 2);

            string err;
            int ico = 0;
            if (sql.add("NewsTree", dimStr, strValue).Equals("发布成功"))
            {
                if (xabara.isNum(oldClassID) > 0) //更新子分类数
                {
                    string strSqlSelect = "select TreeID,idLayerStr from NewsTree where Tid=" + oldClassID + " and TreeType='" + typeClss + "'";
                    DataTable dt = sql.getDataTable(strSqlSelect);
                    if (dt.Rows.Count > 0)
                    {
                        long tidTemp = xabara.isNum(dt.Rows[0]["TreeID"].ToString().Trim());    //更新关联字符串
                        if (tidTemp < 1)
                        {
                            strValue[0] = "|";
                        }
                        else
                        {
                            strValue[0] = dt.Rows[0]["idLayerStr"].ToString();
                        }
                        strValue[0] = strValue[0].Trim() + oldClassID.ToString() + "|";
                        sql.update("NewsTree", "@idLayerStr", strValue, "TreeID=" + oldClassID + " and TreeName='" + classNameTemp + "' and TreeType='" + typeClss + "'");
                    }
                    dt.Dispose();
                }

                sql.log(a.uid, "admin", Server.UrlDecode(titleClass.Text + "：" + classNameTemp));

                err = "成功";
                ico = 6;              
            }
            else
            {
                err = "失败";
                ico = 5;
            }

            js.div("",ico,"", Server.UrlDecode(titleClass.Text) +err,0, "ClassAdd.aspx?tClass=" + typeClss + "&title=" + titleClass.Text + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], "goto");
        }
    }

    protected void adminClass_SelectedIndexChanged(object sender, EventArgs e)
    {
        Session.Add(typeClss, string.Empty); //缓存
        Session.Add("adminClass", adminClass.Text);

        Response.Redirect("ClassAdd.aspx?tClass=" + Request.QueryString["tClass"] + "&title=" + Request.QueryString["title"] + "&cid=" + Request.QueryString["cid"] + "&cidStr=" + Request.QueryString["cidStr"], true);
    }
}
