﻿using System;
using System.Web.UI;
using System.Data;
using xabaraCOM;
public partial class WebXabara_Main : System.Web.UI.Page
{
    admin a = new admin();
    xabara x = new xabara();
    sqlServer s = new sqlServer();
    pcServer pc = new pcServer();

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check(string.Empty);

        if (!Page.IsPostBack)
        {
            //检查版本
            string oldVer = "v2.18.0915";
            xml.save("xabara.config", "webVer", oldVer); //自动更新版本号

            string newVer = url.remoteHttp("http://www.xabara.com/api/ver.aspx?id=" + x.softName(), "utf-8", "", "");
            if (string.IsNullOrWhiteSpace(newVer as string))
            {
                ver.Text = "当前版本：" + oldVer;
            }
            else
            {
                if (xabara.isNum(oldVer.ToLower().Substring(1).Replace(".", "").Replace("beta", "").Trim()) >= xabara.isNum(newVer.ToLower().Substring(1).Replace(".", "").Replace("beta", "").Trim()))
                {
                    ver.Text = "当前版本：" + oldVer + "<br />您已经是最新版本！";
                }
                else
                {
                    ver.Text = "当前版本：" + oldVer + "<br />最新版本：<span style=\"color:#b60202; font-weight:bold;\">" + newVer + "</span> 【<a href=\"http://api.etaocms.com/down/?id=" + x.softName() + "\" target=\"_blank\" style=\"font-weight:bold;\">手工升级</a>】";
                }
            }
            buyLink.NavigateUrl = "http://api.etaocms.com/authorization/?id=" + x.softName();

            adminLog.DataSource = s.getDataTable("select top 6 logLogin.userID,logLogin.loginDate,logLogin.loginIP,AdminUser.UserName from logLogin left join AdminUser on logLogin.UserId=AdminUser.UserId where logLogin.userType='admin' and logLogin.exeTitle='管理员登录' order by logLogin.id desc");
            adminLog.DataBind();
            adminLog.Dispose();

            serverIP.Text = Request.ServerVariables["LOCAL_ADDR"] + ":" + Request.ServerVariables["Server_Port"].ToString();
            ServerOS.Text = Environment.OSVersion.ToString();
            ServerOSVer.Text = pc.os;
            ServerSoft.Text = Request.ServerVariables["SERVER_SOFTWARE"];
            netVer.Text = Environment.Version.ToString();
            ServerPath.Text = Request.ServerVariables["PATH_TRANSLATED"];
            serverTime.Text = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            sqlVer.Text = s.ver(false);

            string infoTxt = "";
            DataTable dt = s.getDataTable("select count(num_iid) as nums from taobaoke");
            infoTxt += "<li style=\"line-height:200%; padding:2px 0px 2px 5px;\">共有 " + dt.Rows[0]["nums"].ToString().Trim() + " 条淘宝收藏，";
            dt.Dispose();

            dt = s.getDataTable("select count(num_iid) as nums from taobaoke where updateDate<'" + DateTime.Now.AddDays(-7).ToString("yyyy-MM-dd") + "'");
            infoTxt += "&nbsp;其中含 " + dt.Rows[0]["nums"].ToString().Trim() + " 条僵尸记录（一周内无任何更新）</li>";
            dt.Dispose();

            dt = s.getDataTable("select count(id) as nums from keywordID where isPP=0");
            infoTxt += "<li style=\"line-height:200%; background-color:#e9f8fc; padding:2px 0px 2px 5px;\">共有 " + dt.Rows[0]["nums"].ToString().Trim() + " 个品牌</li>";
            dt.Dispose();

            infoLJ.Text = infoTxt;
        }
    }

    public string ip(string ipstr)
    {
        ipAddress i = new ipAddress();
        return i.addressCN(ipstr);
    }

    string chkObj(string obj) //自检查
    {
        try
        {
            object meobj = Server.CreateObject(obj);
            return "支持";
        }
        catch (Exception objexe)
        {

            return objexe.Message.ToString();
        }
    }

    public class property
    {
        public string returncode { get; set; }
        public string returnmsg { get; set; }
        public info info { get; set; }
    }

    public class info
    {
        public string usemoney { get; set; }
    }
}