﻿using System;
using System.Web;
using System.Text;
using System.IO;
using System.Net;
using xabaraCOM;
using System.Threading;

public partial class webXabara_frame_htm : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string adminID = "ipUser";
        ipAddress ip = new ipAddress();
        if (xml.read("xabara.config", "ip", 60).IndexOf(ip.address()) < 0)
        {
            admin a = new admin();
            a.check("");

            adminID = a.uid;
        }

        if (!IsPostBack)
        {
            this.CreateUserPage("http://" + Request.Url.Host + "/default.aspx", "");
            Thread.Sleep(5000);
            this.CreateUserPage("http://" + Request.Url.Host + "/top/default.aspx", "top");
            Thread.Sleep(5000);
            this.CreateUserPage("http://" + Request.Url.Host + "/item/default.aspx", "item");
        }
    }

    //生成页面入口
    private void CreateUserPage(string url, string filePath)
    {
        StringBuilder ret = new StringBuilder("");
        Uri uri = new Uri(url);
        HttpWebRequest req = (HttpWebRequest)WebRequest.Create(uri);
        HttpWebResponse rsp = (HttpWebResponse)req.GetResponse();
        Stream rspStream = rsp.GetResponseStream();
        StreamReader sr = new StreamReader(rspStream, Encoding.UTF8);
        //获取数据   
        Char[] read = new Char[256];
        int count = sr.Read(read, 0, 256);
        while (count > 0)
        {
            ret.Append(read, 0, count);
            count = sr.Read(read, 0, 256);
        }

        WriteFile(ret.ToString(), filePath); //按时间生成页面名字
    }

    //生成HTML页 
    public static bool WriteFile(string body, string filePath)
    {
        string path = HttpContext.Current.Server.MapPath("/");  //生成文件的存放目录
        Encoding code = Encoding.GetEncoding("UTF-8");
        StreamWriter sw = null;
        string htmlfilename = "default.html";
        if (!string.IsNullOrWhiteSpace(filePath))
        {
            path = HttpContext.Current.Server.MapPath("~/" + filePath + "/");
        }
        // 写文件 
        try
        {
            sw = new StreamWriter(path + htmlfilename, false, code);
            sw.Write(body);
            sw.Flush();
        }
        catch
        {
            File.WriteAllText(path + DateTime.Now.ToString("yyyyMMdd") + ".log", body, Encoding.UTF8);
            return false;
        }
        finally
        {
            sw.Close();
            sw.Dispose();
            HttpContext.Current.Server.ClearError();

            HttpContext.Current.Response.Write("恭喜&nbsp;" + filePath + "&nbsp;目录&nbsp;<a href=\"/" + filePath + "\" target=\"_blank\">" + htmlfilename + "</a>&nbsp;已经生成成功！<br />");
        }
        return true;
    }
}