﻿using System;
using System.Xml;
using xabaraCOM;

public partial class webXabara_frame_interfaceSet : System.Web.UI.Page
{
    admin a = new admin();
    encryptDecrypt ed = new encryptDecrypt();
    xabara x = new xabara();
    sqlServer sql = new sqlServer();

    public string soft = "";

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check("|interfaceSet|");
        if (!IsPostBack)
        {
            cache.clear();

            string pathFlie = Server.MapPath("/xabara.config");
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(pathFlie);

            appkey.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='appkey']").Attributes["value"].Value;
            appSecret.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='appSecret']").Attributes["value"].Value;
            itemPID.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='itemPID']").Attributes["value"].Value;

            mailSmtp.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='mailSmtp']").Attributes["value"].Value;
            mailAdd.Text = xmlDoc.DocumentElement.SelectSingleNode("//add[@key='mailAdd']").Attributes["value"].Value;
            mailPass.Text = ed.decryptStr(xmlDoc.DocumentElement.SelectSingleNode("//add[@key='mailPass']").Attributes["value"].Value);

            xmlDoc = null;
        }
    }

    protected void sysSet_Click(object sender, EventArgs e)
    {
        string pathFlie = Server.MapPath("/xabara.config");
        XmlDocument xmlDoc = new XmlDocument();
        xmlDoc.Load(pathFlie);

        XmlNodeList topM = xmlDoc.DocumentElement.ChildNodes; //得到顶层节点列表
        foreach (XmlElement xElement in topM)
        {
            if (xElement.Name == "appSettings") //判断读取子层
            {
                XmlNodeList nodelist = xElement.ChildNodes; //得到该节点的子节点               
                if (nodelist.Count > 0)
                {
                    foreach (XmlNode xnode in nodelist)
                    {
                        XmlElement xe = (XmlElement)xnode;

                        string xeStr = xe.Attributes["value"].Value;
                        switch (xe.Attributes["key"].Value) //修改值
                        {
                            case "appkey":
                                xeStr = appkey.Text.Trim();
                                break;
                            case "appSecret":
                                xeStr = appSecret.Text.Trim();
                                break;
                            case "itemPID":
                                xeStr = itemPID.Text.Trim();
                                break;

                            case "mailSmtp":
                                xeStr = mailSmtp.Text.Trim();
                                break;
                            case "mailAdd":
                                xeStr = mailAdd.Text.Trim();
                                break;
                            case "mailPass":
                                xeStr = ed.encryptStr(mailPass.Text.Trim());
                                break;                            
                        }
                        xe.Attributes["value"].Value = xeStr;
                    }
                }
            }
        }

        xmlDoc.Save(pathFlie);
        xmlDoc = null;

        sql.log(a.uid, "admin", "接口设置");

        Response.Redirect("interfaceSet.aspx", true);
    }
}
