﻿using System;
using System.Web;
using System.IO;
using System.Data;
using xabaraCOM;

public partial class webXabara_frame_sitemap : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string adminID = "ipUser";
        ipAddress ip = new ipAddress();
        if (xml.read("xabara.config", "ip", 60).IndexOf(ip.address()) < 0)
        {
            admin a = new admin();
            a.check("");

            adminID = a.uid;
        }

        if (!IsPostBack)
        {
            string id = Request.QueryString["id"];
            if (id.Equals("baidu"))
            {
                id = "";
            }

            writeMap("http://" + Request.Url.Host, Server.MapPath("/sitemap" + id + ".xml"));
        }
    }

    public static void writeMap(string _fullFileName, string mapPath)
    {
        sqlServer sql = new sqlServer();
        classify c = new classify();
        DataTable dt;
        string strLoc = string.Empty;

        string strSql = string.Empty;
        string cidStr = string.Empty;
        string ifStr = string.Empty;

        string id = HttpContext.Current.Request.QueryString["id"];
        string fullFileName = _fullFileName;

        FileInfo XMLFile = null;
        StreamWriter writerXMLFile = null;
        XMLFile = new FileInfo(mapPath);
        writerXMLFile = XMLFile.CreateText();    //添加sitMap的头 
        writerXMLFile.WriteLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (id.Equals("google")) //google　加一句
        {
            writerXMLFile.WriteLine("<urlset xmlns=\"http://www.google.com/schemas/sitemap/0.9\">");
        }
        else
        {
            writerXMLFile.WriteLine("<urlset>");
        }
        
        //频道各首页，每站固定格式
        addXMLSitMap(writerXMLFile, fullFileName, 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/article/default.htm", 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/coupon/", 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/shop/", 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/today/", 1.0);
        addXMLSitMap(writerXMLFile, fullFileName + "/top/", 1.0);

        //店铺
        dt = sql.getDataTable("select id,wordEN from keywordID where isSHOP=1 order by listID DESC");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            string _wordEN = dt.Rows[i]["wordEN"].ToString().Trim();
            if (_wordEN != "")
            {
                strLoc = fullFileName + "/" + dt.Rows[i]["wordEN"].ToString().Trim() + ".htm";
            }
            else
            {
                strLoc = fullFileName + "/" + dt.Rows[i]["id"].ToString().Trim() + ".htm";
            }
            addXMLSitMap(writerXMLFile, strLoc, 0.5);
        }
        dt.Dispose();        

        //新闻系统
        dt = sql.getDataTable("select Tid from newsTree where TreeType='news' order by listID ASC,Tid ASC");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strLoc = fullFileName + "/article/" + dt.Rows[i]["Tid"].ToString().Trim() + ".htm";
            addXMLSitMap(writerXMLFile, strLoc, 0.5);
        }
        dt.Dispose();
        cidStr = c.ReadAllClassID("news", 0); //得到所有ID
        if (cidStr.Length > 1)
        {
            string[] ids = cidStr.Split(new char[] { ',' });
            for (int i = 0; i <= ids.GetUpperBound(0); i++)
            {
                ifStr += "treeTid=" + ids[i].ToString().Trim() + " or ";
            }
            ifStr = " and (" + ifStr.Substring(0, ifStr.Length - 3) + ")";

            strSql = "select Nid from NewsXabara where 1=1 " + ifStr + " order by Nid ASC";
            dt = sql.getDataTable(strSql);
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                strLoc = fullFileName + "/article/view/" + dt.Rows[i]["Nid"].ToString().Trim() + ".htm";
                addXMLSitMap(writerXMLFile, strLoc, 0.5);
            }
            dt.Dispose();
        }

        //产品库
        dt = sql.getDataTable("select num_iid from taobaoke where isBad=0 and volume>49 order by volume desc");
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            strLoc = fullFileName + "/show/" + dt.Rows[i]["num_iid"].ToString().Trim() + ".htm";
            addXMLSitMap(writerXMLFile, strLoc, 0.5);
        }
        dt.Dispose();

        //添加sitMap的尾,千万不能忘了这句
        writerXMLFile.WriteLine("</urlset>");
        writerXMLFile.Close();
        writerXMLFile.Dispose();

        HttpContext.Current.Response.Write("<div style=\"text-align:left;font-size:14px;\"><strong>" + id + " sitemap 生成成功！请分别向以下免费搜索引擎提交：</strong><br /><br />baidu 搜索引擎：<a href=\"http://ziyuan.baidu.com/\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 baidu 提交</strong></a><br /><br />360 搜索引擎：<a href=\"http://zhanzhang.so.com/\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 360 提交</strong></a><br /><br />sogou 搜索引擎：<a href=\"http://zhanzhang.sogou.com/\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 sogou 提交</strong></a><br /><br />bing 搜索引擎：<a href=\"https://www.bing.com/webmaster/\" target=\"_blank\" style=\"color:red;font-size:14px;\"><strong>点击向 bing 提交</strong></a><br /><br /><strong>google sitemap:</strong> http://" + HttpContext.Current.Request.Url.Host + "/sitemapgoogle.xml<br /><br /><strong>other sitemap:</strong> http://" + HttpContext.Current.Request.Url.Host + "/sitemap.xml</div>");
    }
    /// <summary>
    /// 生成站点地图中间部分 
    /// </summary> 
    /// <param name="writerFile"></param>
    /// <param name="strLoc"></param>
    /// <param name="priority"></param> 
    private static void addXMLSitMap(StreamWriter writerFile, string strLoc, double priority)
    {
        writerFile.WriteLine(" <url>");
        writerFile.WriteLine("  <loc>" + strLoc + "</loc>");
        writerFile.WriteLine("  <lastmod>" + DateTime.Now.ToString("yyyy-MM-dd") + "</lastmod>");
        writerFile.WriteLine("  <changefreq>daily</changefreq>");
        writerFile.WriteLine("  <priority>" + priority.ToString("0.0") + "</priority>");
        writerFile.WriteLine(" </url>");
    }
}