﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="webXabara_news_Default" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>管理新闻</title>
    <script src="/js/jquery.min.js" type="text/javascript"></script>
    <script src="/js/all.js" type="text/javascript"></script>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div class="divWidth">
            <div class="titleBg">
                <asp:Label ID="newsTitle" runat="server" Text="管理新闻"></asp:Label>
                <asp:DropDownList ID="cidDropDownList" runat="server" CssClass="inputText" ToolTip="请选择分类，并注意根目录的选择" OnSelectedIndexChanged="cid_SelectedIndexChanged" AutoPostBack="true">
                    <asp:ListItem Value="0">== 分类 ==</asp:ListItem>
                </asp:DropDownList>
                <asp:TextBox ID="keyWord" runat="server" CssClass="inputText" MaxLength="20" Width="300px"></asp:TextBox>&nbsp;<asp:Button ID="search" runat="server" CssClass="inputBottom" OnClick="search_Click"
                    Text="搜索" /><asp:RequiredFieldValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RequiredFieldValidator1"
                        runat="server" ControlToValidate="keyWord" ErrorMessage="请输入关键词"></asp:RequiredFieldValidator>
            </div>
            <div class="height10px">
            </div>
            <div runat="server" id="listNews">
                <asp:Repeater ID="RepeaterListNews" runat="server">
                    <HeaderTemplate>
                        <table width="100%" class="tableLine">
                            <tr>
                                <td class="trTitleBG">
                                    <input name="chkalls" value="1" type="checkbox" onclick="CheckAll(this, 'batDel')" />
                                </td>
                                <td class="trTitleBG">新闻标题
                                </td>
                                <td class="trTitleBG">新闻类型
                                </td>
                                <td class="trTitleBG">阅览数
                                </td>
                                <td class="trTitleBG">发布者
                                </td>
                                <td class="trTitleBG">发布时间
                                </td>
                                <td class="trTitleBG">操作
                                </td>
                            </tr>
                    </HeaderTemplate>
                    <ItemTemplate>
                        <tr>
                            <td style="text-align: center;">
                                <input name="batDel" type="checkbox" value='<%# Eval("upNameID").ToString().Trim()%>' />
                            </td>
                            <td>
                                <a href="/article/show.aspx?id=<%# Eval("Nid").ToString().Trim() %>" target="_blank"><%# Eval("NewTitle").ToString().Trim()%></a><%# !string.IsNullOrWhiteSpace(Eval("newsFrom").ToString().Trim())?"&nbsp;&nbsp;<i>出处："+Eval("newsFrom").ToString().Trim()+"</i>":"" %>
                            </td>
                            <td>
                                <%# getClass(Eval("treeTid").ToString())%>
                            </td>
                            <td style="text-align: center;">
                                <%# Eval("ReadNums").ToString().Trim()%>
                            </td>
                            <td style="text-align: center;">
                                <%# Eval("AdminID").ToString().Trim()%><%# string.IsNullOrWhiteSpace(Eval("userID").ToString().Trim())?"":" ["+Eval("userID").ToString().Trim()+"]"%>
                            </td>
                            <td style="text-align: center;">
                                <%# Convert.ToDateTime(Eval("PostDate").ToString().Trim()).ToString("yyyy-MM-dd HH:mm:ss") %></td>
                            <td style="text-align: center;">
                                <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# Eval("Nid","preview.aspx?sid={0}").ToString().Trim() + "&ifPass=" + ifPass+"&cType="+cTypeTemp+"&page="+Request.QueryString["page"] %>' Font-Bold="True">预览</asp:HyperLink>&nbsp;&nbsp;<asp:HyperLink ID="EditHyperLink"
                                    runat="server" NavigateUrl='<%# Eval("upNameID","edit.aspx?id={0}&cType=").ToString().Trim()+ cTypeTemp+ "&ifPass=" + ifPass+"&page="+Request.QueryString["page"]  %>'
                                    Font-Bold="True">修改</asp:HyperLink>&nbsp;&nbsp;<asp:HyperLink ID="topList" runat="server"
                                        NavigateUrl='<%# Eval("Nid","top.aspx?id={0}").ToString().Trim()+ "&ifPass=" + ifPass + "&cType=" + cTypeTemp+"&page="+Request.QueryString["page"]  %>' Text='<%# Convert.ToDateTime(Eval("TopDate").ToString()) > Convert.ToDateTime(Eval("PostDate").ToString())?"取消置顶":"置顶"%>' Font-Bold="True"></asp:HyperLink>
                            </td>
                        </tr>
                    </ItemTemplate>
                    <AlternatingItemTemplate>
                        <tr>
                            <td style="background-color: #E9F8FC; text-align: center;">
                                <input name="batDel" type="checkbox" value='<%# Eval("upNameID").ToString().Trim()%>' />
                            </td>
                            <td style="background-color: #E9F8FC;">
                                <a href="/article/show.aspx?id=<%# Eval("Nid").ToString().Trim() %>" target="_blank"><%# Eval("NewTitle").ToString().Trim() %></a><%# !string.IsNullOrWhiteSpace(Eval("newsFrom").ToString().Trim())?"&nbsp;&nbsp;<i>出处："+Eval("newsFrom").ToString().Trim()+"</i>":"" %>
                            </td>
                            <td style="background-color: #E9F8FC;">
                                <%# getClass(Eval("treeTid").ToString())%>
                            </td>
                            <td style="background-color: #E9F8FC; text-align: center;">
                                <%# Eval("ReadNums").ToString().Trim()%>
                            </td>
                            <td style="background-color: #E9F8FC; text-align: center;">
                                <%# Eval("AdminID").ToString().Trim()%><%# string.IsNullOrWhiteSpace(Eval("userID").ToString().Trim())?"":" ["+Eval("userID").ToString().Trim()+"]"%>
                            </td>
                            <td style="background-color: #E9F8FC; text-align: center;">
                                <%# Convert.ToDateTime(Eval("PostDate").ToString().Trim()).ToString("yyyy-MM-dd HH:mm:ss") %></td>
                            <td style="background-color: #E9F8FC; text-align: center;">
                                <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%# Eval("Nid","preview.aspx?sid={0}").ToString().Trim() + "&ifPass=" + ifPass+"&cType="+cTypeTemp+"&page="+Request.QueryString["page"] %>' Font-Bold="True">预览</asp:HyperLink>&nbsp;&nbsp;<asp:HyperLink ID="EditHyperLink"
                                    runat="server" NavigateUrl='<%# Eval("upNameID","edit.aspx?id={0}&cType=").ToString().Trim()+ cTypeTemp+ "&ifPass=" + ifPass+"&page="+Request.QueryString["page"]  %>'
                                    Font-Bold="True">修改</asp:HyperLink>&nbsp;&nbsp;<asp:HyperLink ID="topList" runat="server"
                                        NavigateUrl='<%# Eval("Nid","top.aspx?id={0}").ToString().Trim()+ "&ifPass=" + ifPass + "&cType=" + cTypeTemp+"&page="+Request.QueryString["page"]  %>' Text='<%# Convert.ToDateTime(Eval("TopDate").ToString()) > Convert.ToDateTime(Eval("PostDate").ToString())?"取消置顶":"置顶"%>' Font-Bold="True"></asp:HyperLink>
                            </td>
                        </tr>
                    </AlternatingItemTemplate>
                    <FooterTemplate>
                        </table>
                    </FooterTemplate>
                </asp:Repeater>
                <div class="height10px"></div>
                <div style="text-align: center;">全选<input name="chkall" value="1" type="checkbox" onclick="CheckAll(this, 'batDel')" /> <asp:Button ID="batDelete" runat="server" Text="删除" CssClass="inputBottom" OnClientClick="return confirm('确定删除吗？');" OnClick="batDelete_Click" CausesValidation="False" /></div>
            </div>
            <table width="100%" border="0" cellpadding="5" cellspacing="1" bgcolor="#82d1e7"
                runat="server" id="noListNews">
                <tr>
                    <td height="90" style="background-color: #E9F8FC; text-align: center;">
                        <asp:Label ID="errInfo" runat="server" ForeColor="#FF3300"></asp:Label>
                    </td>
                </tr>
            </table>
            <div class="height10px">
            </div>
            <div>
                <asp:Literal ID="lblCurrentPage" runat="server"></asp:Literal>
            </div>
        </div>
    </form>
</body>
</html>
