﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="edit.aspx.cs" Inherits="webXabara_news_edit" ValidateRequest="false" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>修改新闻</title>
    <script src="/js/jquery.min.js" type="text/javascript"></script>
    <script src="/js/all.js" type="text/javascript"></script>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" charset="utf-8" src="/include/ueditor/ueditor.config.js"></script>
    <script type="text/javascript" charset="utf-8" src="/include/ueditor/ueditor.all.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="/include/ueditor/lang/zh-cn/zh-cn.js"></script>
</head>

<body>
    <form id="form1" runat="server">
        <div class="divWidth">
            <div class="titleBg">
                <asp:Label ID="newsName" runat="server" Text="修改新闻"></asp:Label></div><asp:ScriptManager ID="ScriptManager1" runat="server" AsyncPostBackTimeout="3600"></asp:ScriptManager>
        </div>
        <div class="height10px"></div>
        <div class="divWidth">
            <table width="100%" class="tableLine">
                <tr>
                    <td class="tdTitle" style="width: 90px;">新闻标题</td>
                    <td colspan="3" class="tdContent">
                        <asp:TextBox ID="newsTitle" runat="server" CssClass="inputText" Width="700px"
                            Wrap="False" ToolTip="请输入标题" MaxLength="250"></asp:TextBox>
                        <asp:RequiredFieldValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RequiredFieldValidator1" runat="server"
                            ControlToValidate="newsTitle" ErrorMessage="*"></asp:RequiredFieldValidator>
                        <asp:RegularExpressionValidator SetFocusOnError="True" ForeColor="#ff3300" ID="titleRegExpress" runat="server"
                            ControlToValidate="newsTitle"></asp:RegularExpressionValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">新闻分类</td>
                    <td class="tdContent">
                        <asp:DropDownList ID="DropDownListClass" runat="server" CssClass="inputText"
                            ToolTip="请选择分类，并注意根目录的选择">
                        </asp:DropDownList>
                        &nbsp;<asp:RequiredFieldValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RequiredFieldValidator5" runat="server"
                            ControlToValidate="DropDownListClass" ErrorMessage="请选择分类"></asp:RequiredFieldValidator>
                        <asp:Label ID="classInfo" runat="server" ForeColor="#FF3300"></asp:Label>
                    </td>
                    <td class="tdTitle" style="width: 120px;">标题样式</td>
                    <td class="tdContent">
                        <asp:DropDownList ID="colorList" runat="server" CssClass="inputText"
                            ToolTip="标题颜色">
                            <asp:ListItem Value="">== 无 ==</asp:ListItem>
                            <asp:ListItem Value="#FF0000">红色</asp:ListItem>
                            <asp:ListItem Value="#FFFF00">黄色</asp:ListItem>
                            <asp:ListItem Value="#008000">绿色</asp:ListItem>
                            <asp:ListItem Value="#0000FF">蓝色</asp:ListItem>
                            <asp:ListItem Value="#FF00FF">紫红色</asp:ListItem>
                            <asp:ListItem Value="#00FF00">酸橙色</asp:ListItem>
                            <asp:ListItem Value="#00FFFF">水绿色</asp:ListItem>
                            <asp:ListItem Value="#000080">海军蓝</asp:ListItem>
                            <asp:ListItem Value="#808000">橄榄色</asp:ListItem>
                        </asp:DropDownList>
                        <asp:CheckBox ID="checkBold" runat="server" Text="加粗" ToolTip="标题加粗"
                            Font-Bold="True" />
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">新闻内容</td>
                    <td colspan="3">
                        <script id="myEditor" name="myEditor" type="text/plain" style="width: 100%; height: 600px;"><%=_content %></script>
                    </td>
                </tr>
                 <tr>
                    <td class="tdTitle">产品推广</td>
                    <td colspan="3" class="tdContent">
                        <asp:UpdatePanel ID="UpdatePanel1" runat="server" ChildrenAsTriggers="True" RenderMode="Inline" UpdateMode="Conditional">
                            <ContentTemplate>
                                <asp:DropDownList ID="tkClass" runat="server" CssClass="inputText"
                                    ToolTip="请选择分类，并注意根目录的选择" AutoPostBack="True" OnSelectedIndexChanged="tkClass_SelectedIndexChanged">
                                    <asp:ListItem Value="0">== 请选择 ==</asp:ListItem>
                                </asp:DropDownList>
                                <asp:DropDownList ID="ppClass" runat="server" CssClass="inputText"
                                    ToolTip="请选择分类，并注意根目录的选择">
                                    <asp:ListItem Value="0">== 请选择 ==</asp:ListItem>
                                </asp:DropDownList>
                            </ContentTemplate>
                        </asp:UpdatePanel>
                        &nbsp;产品型号<asp:TextBox ID="tkName" runat="server" CssClass="inputText" Width="500px" MaxLength="10"></asp:TextBox>
                        &nbsp;如：iphone8
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">外链网址</td>
                    <td colspan="3" class="tdContent">
                        <asp:TextBox ID="newsHttp" runat="server" CssClass="inputText" Width="300px"
                            Wrap="False" ToolTip="请输入网址" MaxLength="255"></asp:TextBox>
                        <asp:RegularExpressionValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RegHttp" runat="server"
                            ControlToValidate="newsHttp" ErrorMessage="RegularExpressionValidator"></asp:RegularExpressionValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">作　　者</td>
                    <td class="tdContent">
                        <asp:TextBox ID="newAuthor" runat="server" CssClass="inputText" Width="200px"></asp:TextBox>
                    </td>
                    <td class="tdTitle">来　　源</td>
                    <td class="tdContent">
                        <asp:TextBox ID="fromWhere" runat="server" CssClass="inputText" Width="200px"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">发布时间</td>
                    <td class="tdContent" colspan="3">
                        <asp:TextBox ID="pDate" runat="server" Width="200px" MaxLength="50" CssClass="inputTextIME" placeholder="yyyy-MM-dd HH:mm:ss"></asp:TextBox>
                        <asp:RequiredFieldValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RequiredFieldValidator4" runat="server"
                            ControlToValidate="pDate" ErrorMessage="*"></asp:RequiredFieldValidator>
                        <asp:RegularExpressionValidator SetFocusOnError="True" ForeColor="#ff3300" ID="dateRegExpree" runat="server"
                            ControlToValidate="pDate"></asp:RegularExpressionValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle"></td>
                    <td colspan="3" class="tdContent">
                        <asp:Button ID="PostTitle" runat="server" Text="修改新闻" CssClass="inputBottom"
                            OnClick="PostNews_Click" /></td>
                </tr>
            </table>
        </div>
    </form>
     <script type="text/javascript">
         var h = $(window).height() - 402;
         if (h < 455) {
             h = 455;
         }
         var editor = new baidu.editor.ui.Editor({
             textarea: 'myEditor',
             autoHeightEnabled: false,
             elementPathEnabled: true,
             autoFloatEnabled: false,
             initialFrameHeight: h
         });
         editor.render("myEditor");

         layui.use('laydate', function () {
             var laydate = layui.laydate;

             //执行一个laydate实例
             laydate.render({
                 elem: '#pDate' //指定元素
                 , type: 'date'
                 , format: 'yyyy-MM-dd HH:mm:ss'
                 , theme: '#0A7FC3'
             });
         });
    </script>
</body>
</html>
