﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="add.aspx.cs" Inherits="webXabara_shop_add" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>添加店铺</title>
    <script src="/js/jquery.min.js" type="text/javascript"></script>
    <script src="/js/all.js" type="text/javascript"></script>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server" enctype="multipart/form-data">
    <div class="divWidth">
        <div class="titleBg">添加店铺</div>
    </div>
    <div class="height10px">
    </div>
    <div class="divWidth">
        <table width="100%" class="tableLine">
            <tr>
                <td class="tdTitle">
                    分类名称
                </td>
                <td class="tdContent">
                    <asp:DropDownList ID="classID" runat="server" CssClass="inputText" ToolTip="请选择分类" AutoPostBack="True" OnSelectedIndexChanged="classID_SelectedIndexChanged">
                        <asp:ListItem Value="">== 请选择分类 ==</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" 
                        ControlToValidate="classID" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                &nbsp;<asp:Localize ID="adPic" runat="server"></asp:Localize></td>
            </tr>
            <tr>
                <td class="tdTitle">
                    品牌 </td>
                <td class="tdContent">
                    <asp:DropDownList ID="classPP" runat="server" CssClass="inputText" ToolTip="请选择分类" AutoPostBack="True" OnSelectedIndexChanged="classPP_SelectedIndexChanged">
                        <asp:ListItem Value="">== 请选择分类 ==</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" 
                        ControlToValidate="classPP" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    <asp:HiddenField ID="ppEN" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    主显示品牌</td>
                <td class="tdContent">
                    <asp:RadioButtonList ID="isSHOP" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" ForeColor="#FF3300">
                        <asp:ListItem Value="1">是</asp:ListItem>
                        <asp:ListItem Value="0">否</asp:ListItem>
                    </asp:RadioButtonList>
                    <asp:RequiredFieldValidator ID="seoHidValidator0" runat="server" 
                        ControlToValidate="isSHOP" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                &nbsp; 打开品牌店铺时，主显示商品</td>
            </tr>
            <tr>
                <td class="tdTitle">品牌排序</td>
                <td class="tdContent">
                    <asp:TextBox ID="listID" runat="server" CssClass="inputTextIME" Width="50px"></asp:TextBox>
                &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" 
                        ControlToValidate="listID" ErrorMessage="*" ForeColor="#FF3300" SetFocusOnError="True"></asp:RequiredFieldValidator>
                &nbsp;列表页面品牌排序，数字越小越排在前</td>
            </tr>
            <tr>
                <td class="tdTitle">
                    <asp:RequiredFieldValidator SetFocusOnError="True" ForeColor="#ff3300" ID="RequiredFieldValidator4" runat="server" ControlToValidate="showDate" ErrorMessage="*"></asp:RequiredFieldValidator>
                    时间
                </td>
                <td class="tdContent">
                    <asp:TextBox ID="showDate" CssClass="inputTextIME" runat="server" Width="250px"></asp:TextBox>
                &nbsp; 仅在品牌抢购列表页时排序使用</td>
            </tr>
            <tr>
                <td class="tdTitle">
                    品牌LOGO</td>
                <td class="tdContent">
                    <asp:FileUpload ID="logo" runat="server" CssClass="inputTextIME" Width="300px" />
                    &nbsp;&nbsp; 长度：465px 宽度：165px PNG透明格式<asp:HiddenField ID="logoHid" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    LOGO是否独立</td>
                <td class="tdContent">
                    <asp:RadioButtonList ID="isLOGO" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow" ForeColor="#FF3300">
                        <asp:ListItem Value="0">同品牌同LOGO</asp:ListItem>
                        <asp:ListItem Value="1">同品牌不同LOGO</asp:ListItem>
                    </asp:RadioButtonList>
&nbsp; 常见于服装品牌多元化问题，区分LOGO更新问题&nbsp;<asp:RequiredFieldValidator ID="seoHidValidator1" runat="server" 
                        ControlToValidate="isLOGO" ErrorMessage="请认真选择" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                &nbsp;</td>
            </tr>            
            <tr>
                <td class="tdTitle" rowspan="3">
                    宣传图片</td>
                <td class="tdContent">
                    店铺横幅图【可选】&nbsp;<asp:FileUpload ID="bigPic" runat="server" CssClass="inputTextIME" Width="300px" />
                    &nbsp; 长度：700px * 宽度：340px
                    <asp:HiddenField ID="bigPicHid" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="tdContent">
                    特卖列表图 
                    <asp:CheckBox ID="picBak" runat="server" CssClass="inputTextIME" Text="保留" />
&nbsp;<asp:FileUpload ID="listPic" runat="server" CssClass="inputTextIME" Width="300px" />
                    &nbsp; 长度：480px * 宽度：250px <asp:RequiredFieldValidator ID="listPicValidator" runat="server" 
                        ControlToValidate="listPic" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    <asp:HiddenField ID="listPicHid" runat="server" />
                    <asp:HiddenField ID="picBakHid" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="tdContent"><asp:Localize ID="picBakPre" runat="server"></asp:Localize></td>
            </tr>
 <tr>
                <td class="tdTitle">
                    &nbsp;
                </td>
                <td class="tdContent">
                    <asp:Button ID="add" runat="server" Text="更新店铺" CssClass="inputBottom" 
                        onclick="taobaoKe_Click" />
                </td>
            </tr>
	<tr>
                <td class="tdTitle">
                    SEO关键词</td>
                <td class="tdContent">
                    <asp:TextBox ID="seo" runat="server" CssClass="inputText" Width="100%" Height="40px" MaxLength="50" TextMode="MultiLine"></asp:TextBox>
                    <br />
                    不要超过100个汉字，以便于搜索引擎收录<asp:RequiredFieldValidator ID="seoHidValidator" runat="server" 
                        ControlToValidate="seo" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="tdTitle">
                    品牌简介</td>
                <td class="tdContent">
                    <asp:TextBox ID="aboutTxt" runat="server" CssClass="inputText" Width="100%" Height="100px" MaxLength="50" TextMode="MultiLine"></asp:TextBox>
                    </td>
            </tr>           
        </table>
    </div>
        <div class="height10px"></div>
        <div><asp:Literal ID="pic" runat="server"></asp:Literal></div>
    </form>
    <script type="text/javascript">
        layui.use('laydate', function(){
          var laydate = layui.laydate;
  
          //执行一个laydate实例
          laydate.render({
              elem: '#showDate' //指定元素
              , type: 'date'
              , format: 'yyyy-MM-dd'
              , theme: '#0A7FC3'
              , range: '~'
          });
        });
    </script>
</body>
</html>
