﻿using System;
using System.Web;
using System.Web.UI;
using System.Data;
using Top.Api;
using xabaraCOM;
using Top.Api.Request;
using Top.Api.Response;

public partial class webXabara_shop_coupon : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string adminID = "ipUser";
        ipAddress ip = new ipAddress();
        if (xml.read("xabara.config", "ip", 60).IndexOf(ip.address()) < 0)
        {
            admin a = new admin();
            a.check("");

            adminID = a.uid;
        }

        if (!IsPostBack)
        {
            sqlServer s = new sqlServer();
            DataTable dt;
            string[] strValue = new string[20];

            string appkey = xml.read("xabara.config", "appkey", 60);
            if (string.IsNullOrWhiteSpace(appkey as string))
            {
                Response.Redirect("../frame/interfaceSet.aspx", true);
            }
            string appsecret = xml.read("xabara.config", "appSecret", 60);
            string url = xml.read("xabara.config", "taobaoKeUrl", 60);

            string itemPID = xml.read("xabara.config", "itemPID", 60);
            string[] adzoneId = itemPID.Split(new char[] { '_' });
            long adID = xabara.isNum(adzoneId[3]);

            string keywordID = xabara.isNum(Request.QueryString["id"]).ToString();

            Response.Write("根据关键词自动同步店铺优惠券宝贝开始，如出现死机或出错，重新点击 <a href=\"coupon.aspx?id=" + keywordID + "\">自动更新</a> 即可；<br />");

            string strSql = "select top 1 taobaoke.cat_leaf_name,t.* from ( SELECT top 1 NewsTree.Tid,NewsTree.TreeName,keywordID.wordName,keywordID.id from NewsTree left join keywordID on NewsTree.Tid=keywordID.treeID where keywordID.isSHOP=1 and keywordID.couponDate<'" + DateTime.Now.AddHours(-24).ToString() + "') as t left join taobaoke on taobaoke.classID=t.Tid and taobaoke.keywordID=t.id order by taobaoke.volume desc";
            dt = s.getDataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                string keyID = dt.Rows[0]["id"].ToString();
                string classID = dt.Rows[0]["Tid"].ToString().Trim();
                string className = dt.Rows[0]["cat_leaf_name"].ToString().Trim();
                if(string.IsNullOrWhiteSpace(className))
                {
                    className = dt.Rows[0]["TreeName"].ToString().Trim();
                }
                string keyword = className + " " + dt.Rows[0]["wordName"].ToString().Trim();

                this.js();  //定时刷新

                Response.Write("<br />" + keyword + "　正在同步，请等待下一个关键词更新...<br /><br />");

                ITopClient topClient = new DefaultTopClient(url, appkey, appsecret);
                TbkDgItemCouponGetRequest req = new TbkDgItemCouponGetRequest();
                req.AdzoneId = adID;
                req.Platform = 1L;
                req.PageSize = 50L;
                req.Q = keyword;
                req.PageNo = 1L;
                TbkDgItemCouponGetResponse response = topClient.Execute(req);

                long shopNums = response.Results.Count;

                Response.Write("本次共获取了优惠券数：" + shopNums.ToString() + "<br /><br />");
                //Response.Write(response.Body.ToString());
                //Response.End();

                if (shopNums > 0)
                {
                    string strDim = "@seller_id,@classID,@keywordID,@user_type,@nick,@coupon_total_count,@coupon_remain_count,@couponMoney,@couponMaxMoney,@coupon_info,@coupon_start_time,@coupon_end_time,@coupon_click_url,@pic_url,@title";
                    for (int i = 0; i < shopNums; i++)
                    {
                        string couponInfo = response.Results[i].CouponInfo;
                        if (!string.IsNullOrWhiteSpace(couponInfo))//数据存在非优惠券信息
                        {
                            string _sellerID = response.Results[i].SellerId.ToString();                            

                            //判断有效店铺
                            DataTable dtShop = s.getDataTable("select top 1 nick,pic_url from taobaoke where seller_id=" + _sellerID + " and volume>1 order by newid()");
                            if (dtShop.Rows.Count > 0)
                            {
                                // 旺旺ID response.Results[i].Nick
                                string _nick = dtShop.Rows[0]["nick"].ToString().Trim();

                                strValue[0] = _sellerID;
                                strValue[1] = classID;
                                strValue[2] = keyID;
                                strValue[3] = response.Results[i].UserType.ToString();
                                strValue[4] = _nick;
                                strValue[5] = response.Results[i].CouponTotalCount.ToString();
                                strValue[6] = response.Results[i].CouponRemainCount.ToString();
                                //优惠券拆解                            
                                string[] cInfo = couponInfo.Replace("元", "").Substring(1).Split(new char[] { '减' });
                                strValue[7] = cInfo[1];
                                strValue[8] = cInfo[0];
                                strValue[9] = couponInfo;
                                strValue[10] = response.Results[i].CouponStartTime;
                                strValue[11] = response.Results[i].CouponEndTime;
                                strValue[12] = response.Results[i].CouponClickUrl;
                                strValue[13] = response.Results[i].PictUrl;
                                strValue[14] = response.Results[i].Title;

                                DataTable dtIf = s.getDataTable("select * from coupon where seller_id=" + _sellerID + " and coupon_info='" + couponInfo + "'");  //防止重复插入
                                if (dtIf.Rows.Count > 0)
                                {
                                    s.update("coupon", strDim, strValue, " seller_id=" + _sellerID + " and coupon_info='" + couponInfo + "'");
                                }
                                else
                                {
                                    s.add("coupon", strDim, strValue);                                    
                                }
                                dtIf.Dispose();
                            }
                            dtShop.Dispose();
                        }
                    }
                }
                else
                {
                    Response.Write("同步有异常：<br />" + keyword + "<br />");
                    Response.Write(response.Body.ToString());
                    //s.log("taobaoke", "admin", "无效优惠券关键词:" + keyword);
                }

                //更新关键词同步时间
                strValue[0] = DateTime.Now.ToString();
                s.update("keywordID", "@couponDate", strValue, "id=" + keyID);
            }
            else
            {
                Response.Redirect("clear.aspx", true);
            }
            //宝贝同步结束
            dt.Dispose();
        }
    }

    /// <summary>
    /// js方式输出
    /// </summary>
    /// <param name="str">js代码</param>
    /// <returns></returns>
    private void js()
    {
        string str = "<script type=\"text/javascript\">window.setTimeout(\"window.location.href='coupon.aspx?tmp=" + xabara.rnd("123", 6) + "'\",30000)</script>";

        ClientScriptManager cs = ((Page)HttpContext.Current.CurrentHandler).ClientScript;
        cs.RegisterClientScriptBlock(this.GetType(), "ClientScriptBlock", str);
    }
}