﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="keyWordAdd.aspx.cs" Inherits="webXabara_shop_keyWordAdd" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>添加关键词</title>
    <script src="/js/jquery.min.js" type="text/javascript"></script>
    <script src="/js/all.js" type="text/javascript"></script>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />   
    <style type="text/css">
        body {
            margin-left: 0px;
            margin-top: 15px;
            margin-right: 10px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div class="divWidth">
            <div class="titleBg">添加关键词</div>
            <asp:ScriptManager ID="ScriptManager1" runat="server" AsyncPostBackTimeout="3600"></asp:ScriptManager>
        </div>
        <div class="height10px">
        </div>
        <div class="divWidth">
            <table width="100%" class="tableLine">
                <tr>
                    <td class="tdTitle">
                        <strong>分类名称</strong>
                    </td>
                    <td class="tdContent">

                        <asp:DropDownList ID="classID" runat="server" CssClass="inputText"
                            ToolTip="请选择分类" AutoPostBack="True"
                            OnSelectedIndexChanged="classID_SelectedIndexChanged">
                            <asp:ListItem Value="">== 请选择分类 ==</asp:ListItem>
                        </asp:DropDownList>

                        &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server"
                            ControlToValidate="classID" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">品牌中文名</td>
                    <td class="tdContent">
                        <asp:TextBox ID="wordName" runat="server" CssClass="inputText" Width="300px"></asp:TextBox>
                        &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server"
                            ControlToValidate="wordName" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">品牌英文名</td>
                    <td class="tdContent">
                        <asp:TextBox ID="wordEN" runat="server" CssClass="inputText" Width="300px"></asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator7" runat="server"
                            ControlToValidate="wordEN" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                        &nbsp; 品牌使用时请用英文或拼音，将作为整个品牌关联使用</td>
                </tr>
                <tr>
                    <td class="tdTitle">搜索关键词
                    </td>
                    <td class="tdContent">
                        <asp:TextBox ID="keyword" runat="server" CssClass="inputText" Width="300px"></asp:TextBox>
                        &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server"
                            ControlToValidate="keyword" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    &nbsp;中间尽量不要留空格</td>
                </tr>
                <asp:UpdatePanel ID="UpdatePanel1" runat="server" ChildrenAsTriggers="True" RenderMode="Inline" UpdateMode="Conditional">
                    <ContentTemplate>
                        <tr>
                            <td class="tdTitle">是否品牌</td>
                            <td class="tdContent">
                                <asp:RadioButtonList ID="isPP" runat="server"
                                    RepeatDirection="Horizontal" RepeatLayout="Flow" DataTextFormatString="PP" AutoPostBack="True" OnSelectedIndexChanged="isPP_SelectedIndexChanged" ForeColor="#FF3300">
                                    <asp:ListItem Value="0" Selected="True">是</asp:ListItem>
                                    <asp:ListItem Value="1">否</asp:ListItem>
                                    <asp:ListItem Value="2">标签</asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                        </tr>
                        <tr>
                            <td class="tdTitle">关联品牌</td>
                            <td class="tdContent">
                                <asp:DropDownList ID="ppID" runat="server" CssClass="inputText"
                                    ToolTip="请选择关联品牌">
                                    <asp:ListItem Value="0">== 非品牌类关联 ==</asp:ListItem>
                                </asp:DropDownList>
                                &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidatorpp" runat="server"
                            ControlToValidate="ppID" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                    </ContentTemplate>
                </asp:UpdatePanel>
                <tr>
                    <td class="tdTitle">搜索范围</td>
                    <td class="tdContent">
                        <asp:RadioButtonList ID="isTmall" runat="server"
                            RepeatDirection="Horizontal" RepeatLayout="Flow">
                            <asp:ListItem Value="true">天猫</asp:ListItem>
                            <asp:ListItem Value="false" Selected="True">全站</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">排序</td>
                    <td class="tdContent">
                        <asp:RadioButtonList ID="sort" runat="server"
                            RepeatDirection="Horizontal" RepeatLayout="Flow">
                            <asp:ListItem Value="total_sales" Selected="True">销量</asp:ListItem>
                            <asp:ListItem Value="tk_total_sales">累计推广量</asp:ListItem>
                            <asp:ListItem Value="tk_total_commi">总支出佣金</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">搜索价格范围</td>
                    <td class="tdContent">从 
                    <asp:TextBox ID="startPrice" runat="server" CssClass="inputTextIME"
                        Width="80px" Style="text-align: center;">100</asp:TextBox>
                        &nbsp;元至 
                    <asp:TextBox ID="endPrice" runat="server" CssClass="inputTextIME"
                        Width="80px" Style="text-align: center;">20000</asp:TextBox>
                        元<asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server"
                            ControlToValidate="startPrice" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server"
                            ControlToValidate="endPrice" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                        <asp:RegularExpressionValidator SetFocusOnError="True" ForeColor="#ff3300" ID="startPriceRegExpre"
                            runat="server" ControlToValidate="startPrice"></asp:RegularExpressionValidator>
                        <asp:RegularExpressionValidator SetFocusOnError="True" ForeColor="#ff3300" ID="endPriceRegExpre"
                            runat="server" ControlToValidate="endPrice"></asp:RegularExpressionValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">白名单</td>
                    <td class="tdContent">
                        <asp:TextBox ID="vipUser" runat="server" CssClass="inputTextIME" Width="200px"></asp:TextBox>
                    &nbsp; 获取同一个店铺商品时，请填写此店铺淘宝帐号（用户名）</td>
                </tr>
                <tr>
                    <td class="tdTitle">说明</td>
                    <td class="tdContent">添加一个新关键词前，建议去 <a href="http://www.taobao.com" target="_blank">淘宝网站</a>
                        搜索一下，看结果是否符合分类要求。<br />
                        品牌“是”分类属于页面品牌分类，其中“否”与&quot;标签&quot;作为对同一个品牌类关键词搜索补充，但要选择关联品牌。</td>
                </tr>
                <tr>
                    <td class="tdTitle">&nbsp;
                    </td>
                    <td class="tdContent">
                        <asp:Button ID="keywords" runat="server" Text="确定添加" CssClass="inputBottom"
                            OnClick="keywords_Click" />
                    </td>
                </tr>
            </table>
        </div>
        <div class="height10px"></div>
        <div class="divWidth">
            <table cellpadding="0" cellspacing="0" border="0" align="left" class="tableLine">
                <tr>
                    <td class="tdTitle" style="text-align: center;">ID</td>
                    <td class="tdTitle" style="text-align: center;">显示名与关键词</td>
                    <td class="tdTitle" style="text-align: center;">品牌</td>
                    <td class="tdTitle" style="text-align: center;">店铺</td>
                    <td class="tdTitle" style="text-align: center;">范围</td>
                    <td class="tdTitle" style="text-align: center;">排序</td>
                    <td class="tdTitle" style="text-align: center;">价格范围</td>
                    <td class="tdTitle" style="text-align: center;">状态</td>
                    <td class="tdTitle" style="text-align: center;">操作</td>
                </tr>
                <asp:Repeater ID="keyWordList" runat="server">
                    <ItemTemplate>
                        <tr>
                            <td><%# Eval("id").ToString().Trim()%></td>
                            <td><%# Eval("wordName").ToString().Trim()+" <span style=\"color:red;\">"+Eval("keywords").ToString().Trim()+"</span>"%></td>
                            <td><%# Eval("isPP").ToString().Trim().Equals("0")?Eval("wordEN").ToString().Trim():"【"+Eval("wordEN").ToString().Trim()+"】 关联ID："+Eval("ppID").ToString().Trim()%></td>
                            <td style="text-align: center;"><%# Eval("isSHOP").ToString().Trim().Equals("1")?"是":"否"%></td>
                            <td style="text-align: center;"><%# Eval("isTmall").ToString().Trim().Equals("true")?"天猫":"全站"%></td>
                            <td style="text-align: center;"><%# Eval("sort").ToString().Trim()%></td>
                            <td><%# Eval("startPrice").ToString().Trim() + " - " + Eval("endPrice").ToString().Trim()%></td>
                            <td style="text-align: center;"><%# Eval("isBad").ToString().Trim().Equals("0")?"启用":"禁用"%></td>
                            <td style="text-align: center;"><a href="keyWordEdit.aspx?id=<%# Eval("id").ToString().Trim()%>" style="font-weight: bold;">修改</a></td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
            </table>
        </div>
    </form>
</body>
</html>
